@php
    $social_shaing = config('ThemeOptions.social_shaing_on_post');
	$category_on 	= config('ThemeOptions.category_on',true);
	$date_on 	 	= config('ThemeOptions.date_on',true);
    $pre_next_post_on        = config('ThemeOptions.pre_next_post_on',true);
	$blog_options 	= ThemeOption::GetBlogOptionById(optional($blog)->id);
	
	$post_show_sidebar		= $show_sidebar;
	$post_sidebar_layout	= $layout;
	$post_sidebar			= $sidebar;
	$featured_image			= $blog_options['featured_image'] ?? true;
	$featured_img_on 	 	= config('ThemeOptions.featured_img_on',true); /* From Theme Options */
	
    $comment_count_on = config('ThemeOptions.comment_count_on',true);
    $comment_view_on = config('ThemeOptions.comment_view_on',true);

	if( !$post_show_sidebar || empty($post_sidebar) || $post_sidebar_layout == 'full' || !config('ThemeOptions.show_sidebar',true))
	{
		$is_sidebar = false;
		$classes = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12';
		
	}else{
		$is_sidebar = true;
		$classes = 'col-xl-9 col-lg-8 col-md-12 col-sm-12 col-12';
	}
	
	if ($featured_image && $featured_img_on && !empty(@$blog->feature_img->value)) {
		$content_class = 'col-lg-6';
	}else{
		$content_class = 'col-lg-12';
	}
	$container = ($is_sidebar)?'container':'min-container';

@endphp
<div class="section-full content-inner bg-white">
	<div class="{{ $container }}">
		<div class="blog-post duet">
			<div class="row">
				
                <!-- Post Featured Image -->
                @if ($featured_image && $featured_img_on && !empty(@$blog->feature_img->value))
				<div class="col-lg-6">
					<figure>
						<img src="{{ DzHelper::getStorageImage('storage/blog-images/'.@$blog->feature_img->value) }}" alt="{{ __('Blog Image') }}">
					</figure>
				</div>
				@endif
				<!-- End Post Featured Image -->

                
                <div class="{{$content_class}}">
					
                    <div class="section-head">
						
                        <!-- Blog Category Listing --> 
                        @if ($category_on && !empty($blog->blog_categories))
						<ul class="cat-list">
	                        @forelse($blog->blog_categories as $blogcategory)
	                        <li class="title-sm post-tag"><a href="{!! DzHelper::laraBlogCategoryLink($blogcategory->id) !!}">{{ $blogcategory->title }}</a></li>
	                        @empty
	                        <li><a href="javascript:void(0);">{{ __('uncatagorized') }}</a></li>
	                        @endforelse
	                    </ul>
						@endif
						<!-- Blog Category Listing -->

                        <!-- Mantain Blog Visibility Status with Title -->
                        @php
		                    if($blog->visibility != 'Pu'){
		                        $blog_visibility = $blog->visibility == 'Pr' ? __('Private: ') : __('Protected: ');
		                    }else {
		                        $blog_visibility = '';
		                    }
		                @endphp
                        <!-- End Mantain Blog Visibility Status with Title -->
	                    
                        <h2 class="title-head">{{ $blog_visibility }}{{ $blog->title }}</h2>
						<span class="title-sep left"></span>
					</div>	
					
                    <!-- Post Content  -->
                    <div class="dlab-post-info">
						<div class="dlab-post-text text">
							{{-- <p class="blog-excerpt fs-5">{{ optional($blog)->excerpt }}</p> --}}
                            {!! $blog->content !!}
							<div class="clearfix"></div>
						</div>
					</div>
                    <!-- End Post Content  -->

				</div>

				<!-- Blog Meta -->
                <div class="col-12">
					<div class="blog-card-info style-1 no-bdr">
						<div class="date">@if ($date_on){{ $blog->publish_on }}@endif</div>
                        @php
                            $permalink = DzHelper::laraBlogLink($blog->id);
                            $image = '';
                            if (optional($blog->feature_img)->value && Storage::exists('public/blog-images/'.$blog->feature_img->value)) {
                                $image = asset('storage/blog-images/'.$blog->feature_img->value);
                            }
                        @endphp
                        @if ($social_shaing)
                            {!! DzHelper::getBlogShareButton($blog->title, $permalink, $image) !!}
                        @endif
                        <div>
                            <a href="#respond" class="btn-link comment">{{ __('WRITE A COMMENT') }}</a>
                        </div>
					</div>
				</div>
                <!-- End Blog Meta -->
            </div>
		</div>
		
        <div class="row">

            <!-- Left Sidebar Include in enable -->
            @if ($post_sidebar_layout == 'left' && config('ThemeOptions.show_sidebar',true) && $is_sidebar)
			<div class="col-xl-3 col-lg-4 col-md-12 col-sm-12 col-12">
				<div class="side-bar p-r30 sticky-top">
					@include('widgets.sidebar')
				</div>
			</div>
			@endif
			<!-- End Left Sidebar Include if enable -->


            
			<div class="{{ $classes }}">
                
                <!-- Author Box --> 
                @include('elements.author_block_element')
                <!-- End Author Box -->

                <!-- Blog Pagination NextBlog - PreBlog   -->
                @if ($pre_next_post_on && isset($blogs) && count($blogs) > 0)
                <div class="post-btn">
                    <div class="prev-post">
                        <img src="{{ DzHelper::getStorageImage('storage/blog-images/'.@$blogs[0]->feature_img->value) }}" alt="{{ __('Blog Image') }}">
                        <h6 class="title">
                            <a href="{{ DzHelper::laraBlogLink($blogs[0]->id) }}">{{ Str::limit($blogs[0]->title, 24, '..') }}</a>
                            <span class="post-date">{{ $blogs[0]->publish_on }}</span>
                        </h6>
                    </div>
                    <div class="next-post">
                        <h6 class="title">
                        <a href="{{ DzHelper::laraBlogLink($blogs[1]->id) }}">{{ Str::limit($blogs[1]->title, 24, '..') }}</a>
                        <span class="post-date">{{ $blogs[1]->publish_on }}</span></h6>
                        <img src="{{ DzHelper::getStorageImage('storage/blog-images/'.@$blogs[1]->feature_img->value) }}" alt="{{ __('Blog Image') }}">
                    </div>
                </div>
                @endif
                <!-- End Blog Pagination NextBlog - PreBlog   -->
                
                @if (optional($blog)->comment)
                <div class="clear m-b30" id="comment-list">
                    <div class="comments-area" id="comments-div">
                        
                        <h6 class="comments-title"><span>@if ($comment_count_on){{ $total_comments }}@endif {{ __('Comments') }}</span></h6>
                        @if($comments->isNotEmpty() && $comment_view_on)
                            <ol class="comment-list">
                                @forelse($comments as $comment)
                                    <li class="comment">
                                        <div class="comment-body">
                                            <div class="comment-author vcard">
                                                @if (optional($comment->user)->profile && Storage::exists('public/user-images/'.$comment->user->profile))
                                                    <img class="avatar photo" src="{{ asset('storage/user-images/'.$comment->user->profile) }}" alt=""> 
                                                @else
                                                    <img class="avatar photo" src="{{ asset('images/no-user.png') }}" alt=""> 
                                                @endif
                                                <cite class="fn">{{ $comment->commenter }}</cite>
                                            </div>
                                            <div class="comment-meta">
                                                <span>{{ \Carbon\Carbon::parse($comment->created_at)->format('d , F, Y') }}</span>
                                            </div>
                                            <div class="reply">
                                                <a rel="nofollow" href="{{ DzHelper::laraPageLink($blog->id) }}?replytocom={{ $comment->id }}#respond" class="comment-reply-link w3-comment-reply" data-commentid="{{ $comment->id }}" data-postid="{{ $blog->id }}" data-replyto="Reply to {{ $comment->commenter }}"> 
                                                <i class="fa fa-reply"></i>
                                                </a> 
                                            </div>
                                            <div class="comment-info">
                                                <p>{{ $comment->comment }}</p>
                                            </div>
                                        </div>
                                        @if (isset($comment->child_comments) && $comment->child_comments->isNotEmpty())
                                            @include('elements.child_comments', ['comments' => $comment->child_comments,'parent_comment' => $comment->commenter, 'depth' => 1])
                                        @endif
                                    </li>
                                @empty
                                @endforelse
                            </ol>
                        @endif
                        
                            @if(config('Discussion.page_comments'))
                        <div class="mb-4">
                        
                                {!! $comments->links('elements.pagination') !!}
                        </div>
                            @endif
                        
                        @if(!config('Discussion.registration_comment'))
                            <div id="ReplyFormContainer">
                                @if(Session::has('unapprove_comment_error'))
                                    <div class="alert alert-danger alert-dismissible alert-alt fade show">
                                        <strong>{{ __('common.error') }}</strong> {{ Session::get('unapprove_comment_error') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close">
                                    </div>
                                @endif
                                <div class="default-form comment-respond style-1 mb-4" id="respond">
                                    <div class="comment-reply-title text-center mb-3">
                                        <span>{{ __('LEAVE A REPLY') }}</span>
                                    </div>
                                    <h5>
                                        <span id="reply-title"></span>
                                        <small class="fw-normal"> <a rel="nofollow" id="cancel-comment-reply" href="{{ DzHelper::laraBlogLink($blog->id) }}#respond" style="display: none;">{{ __('Cancel reply') }}</a> </small>
                                    </h5>
                                    @auth
                                        <p class="m-t0">{{ __('You are Logged in as') }} <a href="{{ route('admin.users.profile') }}">{{ Auth::user()->name }}</a></p>
                                    @endauth
                                    <form action="{{ route('comments.admin.store') }}" class="comment-form" id="commentform" method="post">
                                        @csrf
                                        @error('commenter')
                                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                                {{ $message }}
                                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                            </div>
                                        @enderror
                                        @error('email')
                                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                                {{ $message }}
                                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                            </div>
                                        @enderror
                                        @error('comment')
                                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                                {{ $message }}
                                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                            </div>
                                        @enderror
        
                                        @if( Session::get('success'))
                                            <div class="m-b30">
                                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                                    {{ Session::get('success') }}
                                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                                </div>
                                            </div>
                                        @endif
                                        <input type="hidden" name="object_id" value="{{ $blog->id }}">
                                        <input type="hidden" name="parent_id" id="comment_parent" value="0">
                                        @guest
                                            <p class="m-b30">
                                                <input type="text" name="commenter" placeholder="{{ __('Name') }}" id="commenter" {{ old('commenter', $comment_author) }} class="form-control" {{ $isRequired }}>
                                            </p>
                                            <p class=" m-b30">
                                                <input type="text" placeholder="{{ __('Email') }}" name="email" id="email" value="{{ old('email', $comment_email) }}" class="form-control" {{ $isRequired }}>
                                            </p>
                                            <p class="m-b30">
                                                <input type="text" placeholder="{{ __('Website url') }}" name="profile_url" id="profileurl" {{ old('profile_url', $comment_url) }} class="form-control">
                                            </p>
                                        @endguest
                                        <p class="comment-form-comment m-b30">
                                            <textarea rows="8" name="comment" placeholder="{{ __('Type Comment here ...') }}" id="comment" class="form-control">{{ old('comment') }}</textarea>
                                        </p>
                                        @guest
                                            @if(config('Discussion.save_comments_cookie'))
                                                <p class="comment-form-comment">
                                                    <input type="checkbox" name="set_comment_cookie" class="form-check-input" id="set_comment_cookie" @checked($comment_author || $comment_email || $comment_url)>
                                                    <label for="set_comment_cookie" class="d-block">{{ __('Remember details for future comments: Name, Email, and Website.') }}</label>
                                                </p>
                                            @endif
                                        @endguest
                                        <p class="form-submit m-b30">
                                            <input href="#respond" type="submit" value="{{ __('Submit Now') }}" class="btn btn-dark btn-skew btn-icon" id="submit">
                                        </p>
                                    </form>
                                </div>
                            </div>
                        @else
                            <p>{{ __('Please') }} <a href="{{ route('admin.login') }}">{{ __('log in') }}</a> {{ __('to post a comment.') }}</p>
                        @endif
                        <!-- Form END -->
                    </div>
                </div>
                @endif
			</div>
            
            
           <!-- Right Sidebar Include if enable -->
			@if ($post_sidebar_layout == 'right' && config('ThemeOptions.show_sidebar',true) && $is_sidebar)
			<div class="col-xl-3 col-lg-4 col-md-5 col-sm-12 col-12">
				<div class="side-bar p-l30 sticky-top">
					@include('widgets.sidebar')
				</div>
			</div>
			@endif
           <!-- End Right Sidebar Include if enable -->

		</div>
	</div>
</div>
