<?php

/* Single Pages Template */
function page_template_options(){
	
	$page_templates = array(
		'landing' => array(
			array(
				'title' => __('Lemars Home 1'),
				'id'   => 'landing_style_1',
				'img'   => asset('/themes/frontend/lemars/images/page-template/landing_style_1.png'),
				'param'  => array()
			),
			array(
				'title' => __('Lemars Home 2'),
				'id'   => 'landing_style_2',
				'img'   => asset('/themes/frontend/lemars/images/page-template/landing_style_2.png'),
				'param'  => array()
			),
			array(
				'title' => __('Lemars Home 3'),
				'id'   => 'landing_style_3',
				'img'   => asset('/themes/frontend/lemars/images/page-template/landing_style_3.png'),
				'param'  => array()
			),
			array(
				'title' => __('Lemars Home 4'),
				'id'   => 'landing_style_4',
				'img'   => asset('/themes/frontend/lemars/images/page-template/landing_style_4.png'),
				'param'  => array()
			),
			array(
				'title' => __('Lemars Home 5'),
				'id'   => 'landing_style_5',
				'img'   => asset('/themes/frontend/lemars/images/page-template/landing_style_5.png'),
				'param'  => array()
			)
		),
		'inner' => array(
			
		),
		'coming' => array(
			array(
				'title' => __('Comingsoon'),
				'id'   => 'coming_style_1',
				'img'   => asset('/themes/frontend/lemars/images/page-template/coming-soon.png'),
				'param'  => array()
			)
		),
		'maintenance' => array(
			array(
				'title' => __('Maintenance'),
				'id'   	=> 'maintenance_style_1',
				'img'   => asset('/themes/frontend/lemars/images/page-template/site-down-for-maintain.png'),
				'param'  => array()
			)
		),
		'error' => array(
			array(
				'title' => __('Error'),
				'id'   => 'error_style_1',
				'img'   => asset('/themes/frontend/lemars/images/page-template/error-404.png'),
				'param'  => array()
			)
		)
	);
	return $page_templates;
}

/* Single Post Layouts */
function post_layouts_options(){

	$post_layouts = array(
		array(
			'id'   => 'standard',
			'layout_param' => array(
		    	'title' => __('Standard'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/standard-post.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'corner_post',
			'layout_param' => array(
		    	'title' => __('Corner Post'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/corner-image-post.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'link_post',
			'layout_param' => array(
		    	'title' => __('Link Post'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/link-post.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'video_post',
			'layout_param' => array(
		    	'title' => __('Video Post'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/video-post.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'audio_post',
			'layout_param' => array(
		    	'title' => __('Audio Post'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/audio-post.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'slider_post_1',
			'layout_param' => array(
		    	'title' => __('Slider Post 1'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/slider-post-1.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'slider_post_2',
			'layout_param' => array(
		    	'title' => __('Slider Post 2'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/slider-post-2.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'slider_post_3',
			'layout_param' => array(
		    	'title' => __('Slider Post 3'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/slider-post-3.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'quote_post',
			'layout_param' => array(
		    	'title' => __('Quote Post'),
		    	'img' => asset('/themes/frontend/lemars/images/post-layout/post-quote.png')
		    ),
			'param'  => array()
		),
	);

	return $post_layouts;
}

/* Header Layouts Options */
function header_style_options(){
	$header_styles = array(
		array(
			'id'   => 'header_1',
			'img_param' => array(
				'title' => __('Style - Normal'),
				'img'   => asset('/themes/frontend/lemars/images/header/header-1.png')
			),
			'param'  => array(
				'class' => '',
				'social_link' => 0,
				'search' => 1,
				'call_to_action_button' => 0,
				'social_links' => 6,
				'top_bar' => 0,
			)
		),
		array(
			'id'   => 'header_2',
			'img_param' => array(
				'title' => __('Style - Center Logo'),
				'img'   => asset('/themes/frontend/lemars/images/header/header-2.png')
			),
			'param'  => array(
				'class' => '',
				'social_link' => 0,
				'search' => 1,
				'call_to_action_button' => 0,
				'social_links' => 6,
				'top_bar' => 0,
			)
		),
		array(
			'id'   => 'header_3',
			'img_param' => array(
				'title' => __('Style - Transparent'),
				'img'   => asset('/themes/frontend/lemars/images/header/header-3.png')
			),
			'param'  => array(
				'class' => '',
				'social_link' => 0,
				'search' => 1,
				'call_to_action_button' => 0,
				'social_links' => 6,
				'top_bar' => 0,
			)
		),
	);

	return $header_styles;
}

/* Foote Layouts Options */
function footer_style_options(){
	$footer_styles = array(
		array(
			'title' => __('Footer 1'),
			'id'   => 'footer_template_1',
			'img'   => asset('/themes/frontend/lemars/images/footer/footer-1.png'),
			'param'  => array(
				'social_link' => 1,
				'copyright'	=> 1,
				'powered_by'	=> 0,
				'sections'	=> 1
			)
		),
	);

	return $footer_styles;
}

/* Sidebar Layouts Options*/
function sidebar_layout_options(){

	$sidebar_layout = array(
		array(
			'id' => 'full',
			'sidebar_param' => array(
				'title' => __('Full Width'),
				'img' 	=> asset('/themes/frontend/lemars/images/sidebar/sidebar-full.png')),
			'param'  => array()
		),
		array(
			'id' => 'left',
			'sidebar_param' => array(
				'title' => __('Left Side'),
				'img' 	=> asset('/themes/frontend/lemars/images/sidebar/sidebar-left.png')),
			'param'  => array()
		),
		array(
			'id' => 'right',
			'sidebar_param' => array(
				'title' => __('Right Side'),
				'img' 	=> asset('/themes/frontend/lemars/images/sidebar/sidebar-right.png')),
			'param'  => array()
		)
	);

	return $sidebar_layout;
}

/* Post Box/Wrapper Style Options */
function post_wrapper_options(){
	
	$post_wrapper_layout = array(
		array(
			'id'   => 'post_box_1',
			'img_param' =>  array(
				'title' => __('Post Box 1'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-1.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_2',
			'img_param' =>  array(
				'title' => __('Post Box 2'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-2.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_3',
			'img_param' =>  array(
				'title' => __('Post Box 3'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-3.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_4',
			'img_param' =>  array(
				'title' => __('Post Box 4'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-4.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_5',
			'img_param' =>  array(
				'title' => __('Post Box 5'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-5.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_6',
			'img_param' =>  array(
				'title' => __('Post Box 6'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-6.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_7',
			'img_param' =>  array(
				'title' => __('Post Box 7'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-7.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_8',
			'img_param' =>  array(
				'title' => __('Post Box 8'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-8.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_9',
			'img_param' =>  array(
				'title' => __('Post Box 9'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-9.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_box_10',
			'img_param' =>  array(
				'title' => __('Post Box 10'),
				'img'   => asset('/themes/frontend/lemars/images/post-box/box-10.png')
			),
			'param'  => array()
		)
	);

	return $post_wrapper_layout;
}

/* Post Listing Style Options */
function post_listing_options(){
	// post listing/collage style
	$post_listing_layout = array(
		array(
			'id'   => 'post_listing_1',
			'listing_param' =>  array(
				'title' => __('Post Listing 1'),
				'img'   => asset('/themes/frontend/lemars/images/post-listing/layout-1.png')),
			'param'  => array()
		),
		array(
			'id'   => 'post_listing_2',
			'listing_param' => array(
				'title' => __('Post Listing 2'),
				'img'   => asset('/themes/frontend/lemars/images/post-listing/layout-2.png')),
			'param'  => array()
		),
		array(
			'id'   => 'post_listing_3',
			'listing_param' =>  array(
				'title' => __('Post Listing 3'),
				'img'   => asset('/themes/frontend/lemars/images/post-listing/layout-3.png')),
			'param'  => array()
		),
		array(
			'id'   => 'post_listing_4',
			'listing_param' =>  array(
				'title' => __('Post Listing 4'),
				'img'   => asset('/themes/frontend/lemars/images/post-listing/layout-4.png')),
			'param'  => array()
		),
		array(
			'id'   => 'post_listing_5',
			'listing_param' =>  array(
				'title' => __('Post Listing 5'),
				'img'   => asset('/themes/frontend/lemars/images/post-listing/layout-5.png')),
			'param'  => array()
		)
	);

	return $post_listing_layout;
}

/* Post Tiles Style Options */
function post_tiles_options(){

	$post_tile_layout = array(
		array(
			'id'   => 'post_tile_1',
			'img_param' =>  array(
				'title' => __('Post Tile 1'),
				'img'   => asset('/themes/frontend/lemars/images/post-tiles/post_tile-1.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'post_tile_2',
			'img_param' => array(
				'title' => __('Post Tile 2'),
				'img'   => asset('/themes/frontend/lemars/images/post-tiles/post_tile-2.png')
			),
			'param'  => array()
		)
	);

	return $post_tile_layout;
}

/* Page Banner Style Options */
function page_banner_options(){
	$page_banner_style = array(
		array(
			'id'   => 'page_banner_big',
			'banner_param' => array(
		    	'title' => __('Fit to Screen'),
		    	'img' => asset('/themes/frontend/lemars/images/page-banner/page-banner-big.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'page_banner_medium',
			'banner_param' => array(
		    	'title' => __('Banner Medium'),
		    	'img' => asset('/themes/frontend/lemars/images/page-banner/page-banner-medium.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'page_banner_small',
			'banner_param' => array(
		    	'title' => __('Banner Small'),
		    	'img' => asset('/themes/frontend/lemars/images/page-banner/page-banner-small.png')
		    ),
			'param'  => array()
		),
		array(
			'id'   => 'page_banner_custom',
			'banner_param' => array(
		    	'title' => __('Custom Height'),
		    	'img' => asset('/themes/frontend/lemars/images/page-banner/page-banner-small.png')
		    ),
			'param'  => array()
		)	
	);

	return $page_banner_style;
}


/* Posts Banners
'param'  => array(
			'limit' => array(3,12),
			'category' => true,
			'type' => array('all','featured', 'most-visited', 'most-liked')
			'post_with' => array('all', 'images-only','without')
			)
limit : array(3,12) : limit select box value start from 3 and end with 12 
array(3) : limit will be 3 fix with disable input box : hint limit is fixed for this 
array(3,15,3) : limit select box values start from 3 and end with 15 with steps 3 like (3,6,9,12,15)  
*/
/* Post Banner Options */

function post_banner_options(){
	$post_banners = array(
		array(
			'id'   => 'post_banner_v1',
			'post_banner_param' => array(
				'title' => __('Post Banner 1'),
				'img'   => asset('/themes/frontend/lemars/images/post-banner/post-slider-v1.png')
			),
			'param'  => array(
				'limit' => array(2,5),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
				)
		),
		array(
			'id'   => 'post_banner_v2',
			'post_banner_param' => array(
				'title' => __('Post Banner 2'),
				'img'   => asset('/themes/frontend/lemars/images/post-banner/post-slider-v2.png')
			),
			'param'  => array(
				'limit' => array(3,12),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
				)
		),
		array(
			'id'   => 'post_banner_v3',
			'post_banner_param' => array(
				'title' => __('Post Banner 3'),
				'img'   => asset('/themes/frontend/lemars/images/post-banner/post-slider-v3.png')
			),
			'param'  => array(
				'limit' => array(3,12),
				'category' => true,
				'type' => array('all','featured', 'most-visited', 'most-liked'),
				'post_with' => array('all', 'images-only','without')
			)    
		)
	);

	return $post_banners;
}

/* Theme Layout Options */
function theme_layout_options(){
	$theme_layouts = array(
		array(
			'id'   => 'theme_layout_1',
			'img_param' => array(
				'title' => __('Full'),
				'img'   => asset('/themes/frontend/lemars/images/theme-layout/full-width.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'theme_layout_2',
			'img_param' => array(
				'title' => __('Box'),
				'img'   => asset('/themes/frontend/lemars/images/theme-layout/boxed.png')
			),
			'param'  => array()
		),
		array(
			'id'   => 'theme_layout_3',
			'img_param' => array(
				'title' => __('Frame'),
				'img'   => asset('/themes/frontend/lemars/images/theme-layout/frame.png')
			),
			'param'  => array()
		)
	);

	return $theme_layouts;
}

/* Theme Color Background Options */
function theme_color_background_options(){
	$theme_color_background = array(
		array(
			'id'   => '#d37b46',
			'img_param' => array(
				'title' => __('Brown'),
				'img'   => asset('/themes/frontend/lemars/images/bg-color/brown.png')
			),
			'param'  => array()      
		),
		array(
			'id'   => '#76c381',
			'img_param' => array(
				'title' => __('Green'),
				'img'   => asset('/themes/frontend/lemars/images/bg-color/green.png')
			),
			'param'  => array()      
		),
		array(
			'id'   => '#e281ef',
			'img_param' => array(
				'title' => __('Pink'),
				'img'   => asset('/themes/frontend/lemars/images/bg-color/pink.png')
			),
			'param'  => array()      
		),
		array(
			'id'   => '#fb4848',
			'img_param' => array(
				'title' => __('Red'),
				'img'   => asset('/themes/frontend/lemars/images/bg-color/red.png')
			),
			'param'  => array()      
		),
		array(
			'id'   => '#008080',
			'img_param' => array(
				'title' => __('Cyan'),
				'img'   => asset('/themes/frontend/lemars/images/bg-color/cyan.png')
			),
			'param'  => array()      
		),
		array(
			'id'   => '#f8ca00',
			'img_param' => array(
				'title' => __('Yellow'),
				'img'   => asset('/themes/frontend/lemars/images/bg-color/yellow.png')
			),
			'param'  => array()      
		)
	);

	return $theme_color_background;
}

/* Theme Image Background Options */
function theme_image_background_options(){
	$theme_image_background = array(
		array(
			'id'   => 'bg_img_1',
			'img'   => asset('/themes/frontend/lemars/images/bg-image/bg_img_1.jpg'),
			'param'  => array()
		),
		array(
			'id'   => 'bg_img_2',
			'img'   => asset('/themes/frontend/lemars/images/bg-image/bg_img_2.jpg'),
			'param'  => array()
		),
		array(
			'id'   => 'bg_img_3',
			'img'   => asset('/themes/frontend/lemars/images/bg-image/bg_img_3.jpg'),
			'param'  => array()
		),
		array(
			'id'   => 'bg_img_4',
			'img'   => asset('/themes/frontend/lemars/images/bg-image/bg_img_4.jpg'),
			'param'  => array()
		)
	);

	return $theme_image_background;
}

/* Theme Pattern Background Options */
function theme_pattern_background_options(){
	$theme_pattern_background = array(
		array(
			'id'   => 'bg_pattern_1',
			'title' => __('Pattern Name 1'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_1.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_2',
			'title' => __('Pattern Name 2'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_2.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_3',
			'title' => __('Pattern Name 3'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_3.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_4',
			'title' => __('Pattern Name 4'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_4.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_5',
			'title' => __('Pattern Name 5'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_5.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_6',
			'title' => __('Pattern Name 6'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_6.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_7',
			'title' => __('Pattern Name 7'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_7.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_8',
			'title' => __('Pattern Name 8'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_8.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_9',
			'title' => __('Pattern Name 9'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_9.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_10',
			'title' => __('Pattern Name 10'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_10.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_11',
			'title' => __('Pattern Name 11'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_11.jpg'),
			'param' => array()
		),
		array(
			'id'   => 'bg_pattern_12',
			'title' => __('Pattern Name 12'),
			'img'   => asset('/themes/frontend/lemars/images/bg-pattern/bg_pattern_12.jpg'),
			'param' => array()
		)
	);

	return $theme_pattern_background;
}

/* Page Loader Options */
function theme_color_options(){
	$theme_color = array(
		array(
			'id'   => 'black-white-light',
			'layout_param'=>array(
				'title' => __('Black & White Light'),
				'img'   => asset('/themes/frontend/lemars/images/skins/black-white-light.png'),
			),
			'color' => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
			'param'  => array()
		),
		
	);

	return $theme_color;
}

/* Page Loader Options */
function page_loader_options(){
	$page_loader = array(
		array(
			'title' => __('Loading 1'),
			'id'   => 'loading1',
			'img'   => asset('/themes/frontend/lemars/images/loading-images/loading1.svg'),
			'param'  => array()
		),
		array(
			'title' => __('Loading 2'),
			'id'   => 'loading2',
			'img'   => asset('/themes/frontend/lemars/images/loading-images/loading2.svg'),
			'param'  => array()
		),
		array(
			'title' => __('Loading 3'),
			'id'   => 'loading3',
			'img'   => asset('/themes/frontend/lemars/images/loading-images/loading3.svg'),
			'param'  => array()
		),
		array(
			'title' => __('Loading 4'),
			'id'   => 'loading4',
			'img'   => asset('/themes/frontend/lemars/images/loading-images/loading4.svg'),
			'param'  => array()
		),
		array(
			'title' => __('Loading 5'),
			'id'   => 'loading5',
			'img'   => asset('/themes/frontend/lemars/images/loading-images/loading5.svg'),
			'param'  => array()
		)
	);

	return $page_loader;
}


/* Sorting Options */
function sort_by_options(){
	$sort_by = array(
		'date_asc'  => __('Date ASC'),
		'date_desc'  => __('Date DESC'),
		'title_asc'  => __('Title ASC'),
		'title_desc'  => __('Title DESC'),
		'most_visited'  => __('Most Visited'),
	);

	return $sort_by;
}

/* Button Link Target Options */
function link_target_options(){
	$link_target = array(
		'_blank' 	=>	__('Opens the link in a new tab.'),
		'_parent' 	=> 	__('Opens the link in the parent frame.'),
		'_self'		=>	__('Open the link in the current frame.'),
		'_top'		=>	__('Opens the link in the top-most frame.'),
	);
	
	return $link_target;
}

/* Advertisement Banner Size Options */
function adsence_size_options(){
	$adsence_size = array(
		'auto' => __('Auto' ),
		'120 x 90' => __('120 x 90'),
		'120 x 240' => __('120 x 240'),
		'120 x 600' => __('120 x 600'),
		'125 x 125' => __('125 x 125'),
		'160 x 90' => __('160 x 90'),
		'160 x 600' => __('160 x 600'),
		'180 x 90' => __('180 x 90'),
		'180 x 150' => __('180 x 150'),
		'200 x 90' => __('200 x 90'),
		'200 x 200' => __('200 x 200'),
		'234 x 60' => __('234 x 60'),
		'250 x 250' => __('250 x 250'),
		'320 x 100' => __('320 x 100'),
		'300 x 250' => __('300 x 250'),
		'300 x 600' => __('300 x 600'),
		'300 x 1050' => __('300 x 1050'),
		'320 x 50' => __('320 x 50'),
		'336 x 280' => __('336 x 280'),
		'360 x 300' => __('360 x 300'),
		'435 x 300' => __('435 x 300'),
		'468 x 15' => __('468 x 15'),
		'468 x 60' => __('468 x 60'),
		'640 x 165' => __('640 x 165'),
		'640 x 190' => __('640 x 190'),
		'640 x 300' => __('640 x 300'),
		'728 x 15' => __('728 x 15'),
		'728 x 90' => __('728 x 90'),
		'970 x 90' => __('970 x 90'),
		'970 x 250' => __('970 x 250'),
		'240 x 400' => __('240 x 400 - Regional ad sizes'),
		'250 x 360' => __('250 x 360 - Regional ad sizes'),
		'580 x 400' => __('580 x 400 - Regional ad sizes'),
		'750 x 100' => __('750 x 100 - Regional ad sizes'),
		'750 x 200' => __('750 x 200 - Regional ad sizes'),
		'750 x 300' => __('750 x 300 - Regional ad sizes'),
		'980 x 120' => __('980 x 120 - Regional ad sizes'),
		'930 x 180' => __('930 x 180 - Regional ad sizes')
	);

	return $adsence_size;
}

/* Social Link Options */
function social_link_options(){
	
	$social_links = array(
	    'facebook' => array(
	        'id' => 'facebook',
	        'title' => 'Facebook',
	    ),
	    'twitter' => array(
	        'id' => 'twitter',
	        'title' => 'Twitter',
	    ),
	    'linkedin' => array(
	        'id' => 'linkedin',
	        'title' => 'Linkedin',
	    ),
	     'instagram' => array(
	        'id' => 'instagram',
	        'title' => 'Instagram',
	    ),
		 'whatsapp' => array(
	        'id' => 'whatsapp',
	        'title' => 'WhatsApp',
	    ),
	    'behance' => array(
	        'id' => 'behance',
	        'title' => 'Behance',
	    ), 
	    'skype' => array(
	        'id' => 'skype',
	        'title' => 'Skype',
	    ), 
	    'pinterest' => array(
	        'id' => 'pinterest',
	        'title' => 'Pinterest',
	    ),
	    'vimeo' => array(
	        'id' => 'vimeo',
	        'title' => 'Vimeo',
	    ),
	    'youtube' => array(
	        'id' => 'youtube',
	        'title' => 'Youtube',
	    ), 
	    'tumblr' => array(
	        'id' => 'tumblr',
	        'title' => 'Tumblr',
	    ),
	     'rss' => array(
	        'id' => 'rss',
	        'title' => 'Rss',
	    ), 
	    'yelp' => array(
	        'id' => 'yelp',
	        'title' => 'Yelp',
	    ),
	    'tripadvisor' => array(
	        'id' => 'tripadvisor',
	        'title' => 'Tripadvisor',
	    ),
	    'blogger' => array(
	        'id' => 'blogger',
	        'title' => 'Blogger',
	    ),
	    'delicious' => array(
	        'id' => 'delicious',
	        'title' => 'Delicious',
	    ), 
	    'digg' => array(
	        'id' => 'digg',
	        'title' => 'Digg',
	    ),
	    'dribbble' => array(
	        'id' => 'dribbble',
	        'title' => 'Dribbble',
	    ),
	    'flickr' => array(
	        'id' => 'flickr',
	        'title' => 'Flickr',
	    ),
	    'lastfm' => array(
	        'id' => 'lastfm',
	        'title' => 'Lastfm',
	    ),
	    'paypal' => array(
	        'id' => 'paypal',
	        'title' => 'Paypal',
	    ), 
	    'reddit' => array(
	        'id' => 'reddit',
	        'title' => 'Reddit',
	    ),
	    'share' => array(
	        'id' => 'share',
	        'title' => 'Share',
	    ),
	    'soundcloud' => array(
	        'id' => 'soundcloud',
	        'title' => 'Soundcloud',
	    ),
	    'spotify' => array(
	        'id' => 'spotify',
	        'title' => 'Spotify',
	    ),
	    'stack-overflow' => array(
	        'id' => 'stack-overflow',
	        'title' => 'Stack Overflow',
	    ), 
	     'steam' => array(
	        'id' => 'steam',
	        'title' => 'Steam',
	    ),
	    'stumbleupon' => array(
	        'id' => 'stumbleupon',
	        'title' => 'Stumbleupon',
	    ),
	    'telegram' => array(
	        'id' => 'telegram',
	        'title' => 'Telegram',
	    ),
	    'twitch' => array(
	        'id' => 'twitch',
	        'title' => 'Twitch',
	    ),
	    'vk' => array(
	        'id' => 'vk',
	        'title' => 'VKontakte',
	    ),
	    'windows' => array(
	        'id' => 'windows',
	        'title' => 'Windows',
	    ), 
	     'wordpress' => array(
	        'id' => 'wordpress',
	        'title' => 'WordPress',
	    ),
	    'yahoo' => array(
	        'id' => 'yahoo',
	        'title' => 'Yahoo',
	    ) 

	);

	return $social_links;
}

/* Social Share Options */
function social_share_options(){
	
	$social_share = array(
	    'facebook' => array(
	        'id' => 'facebook',
	        'title' => 'Facebook',
	    ),
	    'twitter' => array(
	        'id' => 'twitter',
	        'title' => 'Twitter',
	    ),
	    'linkedin' => array(
	        'id' => 'linkedin',
	        'title' => 'Linkedin',
	    ),
	   'pinterest' => array(
	        'id' => 'pinterest',
	        'title' => 'Pinterest',
	    ),
	   'tumblr' => array(
	        'id' => 'tumblr',
	        'title' => 'Tumblr',
	    ),
	   'digg' => array(
	        'id' => 'digg',
	        'title' => 'Digg',
	    ),
	    'reddit' => array(
	        'id' => 'reddit',
	        'title' => 'Reddit',
	    ),

	);

	return $social_share;
}

/* Button Link Target Options */
function banner_type(){
	$banner_type = array(
		'image'  => __('Image Type Banner'),
	);
	
	return $banner_type;
}