<?php

require_once 'functions.php';

if (!class_exists('BlogOptions'))
{
    class BlogOptions
    {
        public $args = array();
        public $sections = array();
        public $theme;

        /** Option Variable Declaration **/
        public $header_style_options;
        public $footer_style_options;
        public $post_layouts_options;
        public $sidebar_layout_options;
        public $page_banner_options;
        public $social_link_options;
        /** Option Variable Declaration End **/

        function __construct() 
        {

            /** Option Variable assigning values **/
            $this->header_style_options = get_header_style_options();
            $this->post_layouts_options = get_post_layouts_options();
            $this->sidebar_layout_options = get_sidebar_layout_options();
            $this->page_banner_options = get_page_banner_options();
            $this->footer_style_options = get_footer_style_options();
            $this->social_link_options = get_social_link_options();
            $this->banner_type = banner_type();
            /** End Option Variable assigning values **/
            
            /* Just for demo purposes. Not needed per say. */
            $themeArr = explode('/', config('Theme.select_theme'));
            $this->theme = $themeArr[1];

            /* Create the sections and fields */
            $this->setSections();
        }
        /**
         * All the possible sections for Redux.
         *
         */
        function setSections()
        {


            $this->sections[] = array(
                'title'  => __('General'),
                'icon'   => 'fas fa-newspaper',
                'fields' => array(
                    array(
                        'id'      => 'featured_post',
                        'type'    => 'checkbox',
                        'title'   => __('Featured Post?'),
                        'desc' => __('Check if you want to make this post as featured post'),
                        'default' => ''
                    ),
                )
            );
            $this->sections[] = array(
                'title' => __('Post Header') ,
                'desc' => __('Header settings for the post.') ,
                'icon' => 'fa fa-window-maximize',
                'fields' => array(
                    array(
                        'id' => 'post_header_setting',
                        'type' => 'button_set',
                        'title' => __('Post Header Settings') ,
                        'options' => array(
                            'theme_default' => __('Theme Default') ,
                            'custom' => __('Custom Setting')
                        ) ,
                        'default' => 'theme_default',
                    ),
                    array(
                        'id' => 'post_header_style',
                        'type' => 'image_select',
                        'title' => __('Header Style') ,
                        'subtitle' => __('Choose header style. White header is set as default header for this post.') ,
                        'options' => $this->header_style_options,
                        'default' => config('ThemeOptions.header_style') ,
                        'force_output' => true,
                        'depend_on' => array(
                            'post_header_setting' => array('operator' => '==',"value" => 'custom')
                        ),
                    ) ,
                )
            );
            $this->sections[] = array(
                'title'  => __('Post Layout'),
                'icon'   => 'fas fa-file-alt',
                'fields' => array(
                    array(
                        'id'       => 'post_layout',
                        'type'     => 'image_select',
                        'height'   => '55',
                        'title'    => __('Layout'),
                        'subtitle' => __('Select a template.'),
                        'desc'     => __('Click on the template icon to select.'),
                        'options'  => $this->post_layouts_options,
                        'default'  => config('ThemeOptions.post_general_layout'),
                        'hint'     => array(
                            'title'   => __('How it Works?'),
                            'content' => __('Once you select the template from here, the template will apply for this page only.')
                        )
                    ),
                    array(
                        'id'      => 'post_type_gallery1',
                        'type'    => 'gallery',
                        'title'   => __('Gallery'),
                        'subtitle' => __('Select the gallery images'),
                        'default' => '',
                        'depend_on' => array(
                            'post_layout' => array('operator' => '==',"value" => 'slider_post_1')
                        ),
                    ),
                    array(
                        'id'      => 'post_type_gallery2',
                        'type'    => 'gallery',
                        'title'   => __('Gallery'),
                        'subtitle' => __('Select the gallery images'),
                        'default' => '',
                        'depend_on' => array(
                            'post_layout' => array('operator' => '==',"value" => 'slider_post_2')
                        ),
                    ),
                    array(
                        'id'      => 'post_type_gallery3',
                        'type'    => 'gallery',
                        'title'   => __('Gallery'),
                        'subtitle' => __('Select the gallery images'),
                        'default' => '',
                        'depend_on' => array(
                            'post_layout' => array('operator' => '==',"value" => 'slider_post_3')
                        ),
                    ),
                    array(
                        'id'       => 'post_type_link',
                        'type'     => 'text',
                        'title'    => __('External Link'),
                        'default'  => '',
                        'validate' => 'url',
                        'depend_on' => array(
                            'post_layout' => array('operator' => '==',"value" => 'link_post')
                        ),
                    ),
                    array(
                        'id'       => 'post_type_quote_author',
                        'type'     => 'text',
                        'title'    => __('Author Name'),
                        'default'  => __('Author Name'),
                        'depend_on' => array(
                            'post_layout' => array('operator' => '==',"value" => 'quote_post')
                        ),
                    ),
                    array(
                        'id'       => 'post_type_quote_text',
                        'type'     => 'textarea',
                        'title'    => __('Quote Text'),
                        'default'  => __('Quote Text'),
                        'depend_on' => array(
                            'post_layout' => array('operator' => '==',"value" => 'quote_post')
                        ),
                    ),
                    array(
                        'id'       => 'post_type_audio',
                        'type'     => 'text',
                        'title'    => __('Sound Cloud Link'),
                        'default'  => '',
                        'validate' => 'url',
                        'depend_on' => array(
                            'post_layout' => array('operator' => '==',"value" => 'audio_post')
                        ),
                    ),
                    array(
                        'id'       => 'post_type_video',
                        'type'     => 'text',
                        'title'    => __('Video Link'),
                        'default'  => '',
                        'validate' => 'url',
                        'depend_on' => array(
                            'post_layout' => array('operator' => '==',"value" => 'video_post')
                        ),
                    ),
                    array(
                        'id'       => 'post_show_sidebar',
                        'type'     => 'switch',
                        'title'    => __('Sidebar'),
                        'desc'     => __('Show / hide sidebar from this posts detail page.'),
                        'on'       => __('Enabled'),
                        'off'      => __('Disabled'),
                        'default'  => config('ThemeOptions.show_sidebar'),
                        'depend_on' => array(
                            'post_layout' => array('operator' => '!=',"value" => 'gutenberg')
                        ),
                    ),
                    array(
                        'id'       => 'post_sidebar_layout',
                        'type'     => 'image_select',
                        'title'    => __('Sidebar Layout'),
                        'subtitle' => __('Choose the layout for page. (Default : Right Side).'),
                        'options'  => $this->sidebar_layout_options,
                        'default'  => 'right',
                        'depend_on' => array(
                            'post_show_sidebar' => array('operator' => '==',"value" => '1')
                        ),
                    ),
                    array(
                        'id'      => 'featured_image',
                        'type'    => 'switch',
                        'title'   => __('Show Feature Image'),
                        'on'       => __('Enabled'),
                        'off'      => __('Disabled'),
                        'default' => 1
                    ),
                    array(
                        'id'      => 'post_pagination',
                        'type'    => 'switch',
                        'title'   => __('Show Post Pagination'),
                        'on'       => __('Enabled'),
                        'off'      => __('Disabled'),
                        'default' => 0
                    ),
                )
            );
            $this->sections[] = array(
                'title' => __('Post Banner') ,
                'desc' => __('Settings for post banner.') ,
                'icon' => 'fas fa-tv',
                'fields' => array(
                    array(
                        'id' => 'post_banner_setting',
                        'type' => 'button_set',
                        'title' => __('Post Banner Settings') ,
                        'options' => array(
                            'theme_default' => __('Theme Default') ,
                            'custom' => __('Custom Setting')
                        ) ,
                        'default' => 'theme_default',
                    ) ,
                    array(
                        'id' => 'post_banner_on',
                        'type' => 'switch',
                        'title' => __('Post Banner') ,
                        'on' => __('Enabled') ,
                        'off' => __('Disabled') ,
                        'default' => config('ThemeOptions.post_general_banner_on') ,
                        'depend_on' => array(
                            'post_banner_setting' => array('operator' => '==',"value" => 'custom')
                        ),
                    ) ,
                    
                    array(
                        'id' => 'post_banner_type',
                        'type' => 'button_set',
                        'title' => __('Post Banner Type') ,
                        'options' => $this->banner_type,
                        'default' => 'image',
                        'depend_on' => array(
                            'post_banner_on' => array('operator' => '==',"value" => '1')
                        ),
                    ),
                    array(
                        'id' => 'post_banner_height',
                        'type' => 'image_select',
                        'title' => __('Post Banner Height') ,
                        'subtitle' => __('Choose the height for all tag page banner. Default : Big Banner') ,
                        'options' => $this->page_banner_options,
                        'height' => '20',
                        'default' => config('ThemeOptions.post_general_banner_height') ,
                        'required' => array(
                            0 => 'post_banner_on',
                            1 => 'equals',
                            2 => 1
                        ) ,
                        'depend_on' => array(
                            'post_banner_on' => array('operator' => '==',"value" => 1)
                        ),
                    ) ,
                    array(
                        'id' => 'post_banner_custom_height',
                        'type' => 'slider',
                        'title' => __('Post Banner Custom Height') ,
                        'desc' => __('Hight description. Min: 100, max: 800') ,
                        'default' => config('ThemeOptions.post_general_banner_height') ,
                        'min' => 100,
                        'max' => 800,
                        'display_value' => 'text',
                        'depend_on' => array(
                            'post_banner_height' => array('operator' => '==',"value" => 'page_banner_custom')
                        ),
                    ) ,
                    
                    array(
                        'id' => 'post_banner',
                        'type' => 'media',
                        'url' => true,
                        'title' => __('Post Banner Image') ,
                        'subtitle' => __('Enter page banner image. It will work as default banner image for all pages') ,
                        'desc' => __('Upload banner image.') ,
                        'default' => config('ThemeOptions.post_general_banner') ,
                        'depend_on' => array(
                            'post_banner_on' => array('operator' => '==',"value" => 1)
                        ),
                    ) ,
                    array(
                        'id' => 'post_breadcrumb',
                        'type' => 'switch',
                        'title' => __('Breadcrumb Area') ,
                        'subtitle' => __('Click on the tab to Enable / Disable the website breadcrumb.') ,
                        'desc' => __('This setting affects only on this page.') ,
                        'on' => __('Enabled') ,
                        'off' => __('Disabled') ,
                        'default' => config('ThemeOptions.show_breadcrumb') ,
                        'depend_on' => array(
                            'post_banner_on' => array('operator' => '==',"value" => 1)
                        ),
                    ) ,
                )
            );
            $this->sections[] = array(
                'title' => __('Post Footer') ,
                'desc' => __('Settings for footer area.') ,
                'icon' => 'fa fa-home',
                'fields' => array(
                    array(
                        'id' => 'post_footer_setting',
                        'type' => 'button_set',
                        'title' => __('Post Footer Settings') ,
                        'options' => array(
                            'theme_default' => __('Theme Default') ,
                            'custom' => __('Custom Setting')
                        ) ,
                        'default' => 'theme_default',
                    ),
                    array(
                        'id'      => 'post_footer_on',
                        'type'    => 'switch',
                        'title'   => __('Footer'),
                        'on'      => __('Enabled'),
                        'off'     => __('Disabled'),
                        'default' => config('ThemeOptions.footer_on'),
                        'depend_on' => array(
                            'post_footer_setting' => array('operator' => '==',"value" => 'custom')
                        ),
                    ),
                    array(
                        'id'       => 'post_footer_style',
                        'type'     => 'image_select',
                        'height'   => '80',
                        'title'    => __('Footer Template'),
                        'subtitle' => __('Choose a template for footer.'),
                        'options'  => $this->footer_style_options,
                        'default'  => config('ThemeOptions.footer_style'),
                        'depend_on' => array(
                            'post_footer_setting' => array('operator' => '==',"value" => 'custom'),
                            'post_footer_on' => array('operator' => '==',"value" => 1)
                        ),
                    )
                )
            );
        }

    }

}
