<?php

namespace Modules\W3Options\ViewComposers;

use Illuminate\View\View;
use Illuminate\Http\Request;
use Hexadog\ThemesManager\Facades\ThemesManager;


if (file_exists(base_path('themes/'.config('Theme.select_theme').'/incudes/w3-options/theme-options.php'))) {
    require_once base_path('themes/'.config('Theme.select_theme').'/incudes/w3-options/theme-options.php');
}

class W3OptionsComposer
{
    /**
     * For Getting Theme Options in Front Site Views.
     */
    public function compose(View $view, Request $request)
    {
        if( !defined('LEMARS_VERSION')) {define('LEMARS_VERSION', '3.2');}
        if( !defined( 'LEMARS_ROOT' ) ) {define('LEMARS_ROOT', url('/'));}
        if( !defined( 'LEMARS_URL' ) ) {define('LEMARS_URL', theme_asset('/'));}

        if( !defined( 'LEMARS_COMINGSOON' ) ) {define('LEMARS_COMINGSOON', theme_asset('/').'images/bg1.jpg');}
        if( !defined( 'LEMARS_MAINTENANCE' ) ) {define('LEMARS_MAINTENANCE', theme_asset('/').'images/bg2.jpg');}
        if( !defined( 'LEMARS_MAINTENANCE_VLC' ) ) {define('LEMARS_MAINTENANCE_VLC', theme_asset('/').'images/vlc.png');}

        if( !defined( 'LEMARS_DEFAULT_LOGO' ) ) {define('LEMARS_DEFAULT_LOGO', theme_asset('/').'images/logo-dark.png');}
        if( !defined( 'LEMARS_DEFAULT_WHITE_LOGO' ) ) {define('LEMARS_DEFAULT_WHITE_LOGO', theme_asset('/').'images/logo.png');}

        if( !defined( 'LEMARS_DEFAULT_TEXT_LOGO' ) ) {define('LEMARS_DEFAULT_TEXT_LOGO', ThemesManager::current()->getName());}

        if( !defined( 'LEMARS_DEFAULT_TAG' ) ) {define('LEMARS_DEFAULT_TAG', __('Personal Blog'));}

        if( !defined( 'LEMARS_BANNER' ) ) {define('LEMARS_BANNER', theme_asset('/').'images/banner/pic2.jpg');}
        if( !defined( 'LEMARS_COPYWRITE_TEXT' ) ) {define('LEMARS_COPYWRITE_TEXT', __('© 2023 All Rights Reserved.'));}
        
        if( !defined( 'LEMARS_FAVICON' ) ) {define('LEMARS_FAVICON', theme_asset('/').'images/favicon.ico');}

        $action = $request->route()->getAction();
        $controller = explode('@', class_basename($action['controller']))[0];
        $dzRes = array();
        $testStr = "";
        $viewName = $view->getName();

        // Added Contains conditions for not runs twice for included Files
        if (($controller == 'HomeController' && !str_contains($viewName, '.')) || in_array($viewName, ['errors.coming_soon','errors.503'])) {
            
            $page = optional($view)->page;
            $blog = optional($view)->blog;
            $user = optional($view)->user;
            
            if ($viewName == 'errors::404') {
                $viewName = '404';
            }
            
            $dzRes['website_status'] = config('ThemeOptions.website_status', 'live_mode');
            
            if (is_file(storage_path('app/public/configuration-images/'.config('ThemeOptions.comingsoon_bg')))) {
                $dzRes['comingsoon_bg'] = asset('storage/configuration-images/'.config('ThemeOptions.comingsoon_bg'));
            }else {
                $dzRes['comingsoon_bg'] = theme_asset('images/banner/pic2.jpg');
            }
            $dzRes['coming_soon_template'] = config('ThemeOptions.coming_soon_template','coming_style_1');
            
            
            /* Maintenence Page Settings */
            if (is_file(storage_path('app/public/configuration-images/'.config('ThemeOptions.maintenance_bg')))) {
                $dzRes['maintenance_bg'] = asset('storage/configuration-images/'.config('ThemeOptions.maintenance_bg'));
            }else {
                $dzRes['maintenance_bg'] = theme_asset('images/banner/pic1.jpg');
            }
            if (is_file(storage_path('app/public/configuration-images/'.config('ThemeOptions.maintenance_icon')))) {
                $dzRes['maintenence_icon'] = asset('storage/configuration-images/'.config('ThemeOptions.maintenance_icon'));
            }else {
                $dzRes['maintenence_icon'] = theme_asset('images/vlc.png');
            }

            $dzRes['maintenance_title'] = config('ThemeOptions.maintenance_title');
            $dzRes['maintenance_desc'] = config('ThemeOptions.maintenance_desc');
            $dzRes['maintenance_template'] = config('ThemeOptions.maintenance_template','maintenance_style_1');
            $dzRes['maintenence_vlc'] = '';
            /* Maintenence Page Settings END */

            $dzRes['site_favicon'] = config('ThemeOptions.site_favicon');
            $dzRes['page_loading_on'] = config('ThemeOptions.page_loading_on');
            $dzRes['page_loader_type'] = config('ThemeOptions.page_loader_type');


            if($dzRes['page_loading_on'] == 1)
            {
                if($dzRes['page_loader_type'] == 'loading_image')
                {
                    if(!empty(config('ThemeOptions.custom_page_loader_image'))) {
                        $dzRes['preloader'] = config('ThemeOptions.custom_page_loader_image');
                    }
                    else {
                        $page_loader_image = config('ThemeOptions.page_loader_image', '');
                        $dzRes['preloader'] = theme_asset('images/loading-images/'.$page_loader_image.'.svg');
                    }
                }   
                elseif($dzRes['page_loader_type'] == 'advanced_loader')
                {
                    $dzRes['preloader'] = config('ThemeOptions.advanced_page_loader_image', '');
                }   
            }

            /* header settings */
            $dzRes['header_style'] = config('ThemeOptions.header_style', 'header_1');
            $dzRes['footer_style'] = config('ThemeOptions.footer_style', 'footer_template_1');
            $dzRes['footer_on'] = config('ThemeOptions.footer_on', true);
            $header_setting_meta_key = '';
            $footer_setting_meta_key = '';
            /* Get Header & Footer: According to CPT */
            
            if ($viewName == 'page') {
                $header_setting_meta_key    = 'page_header_setting';
                $header_style_meta_key      = 'page_header_style';

                $footer_setting_meta_key    = 'page_footer_setting';
                $footer_style_meta_key      = 'page_footer_style';
                $footer_on_meta_key         = 'page_footer_on';
            }
            else if($viewName == 'single') 
            {
                $header_setting_meta_key    = 'post_header_setting';
                $header_style_meta_key      = 'post_header_style';

                $footer_setting_meta_key    = 'post_footer_setting';
                $footer_style_meta_key      = 'post_footer_style';
                $footer_on_meta_key         = 'post_footer_on';
            }

            $header_setting = !empty($page) ? \ThemeOption::GetPageOptionById(optional($page)->id, $header_setting_meta_key) : \ThemeOption::GetBlogOptionById(optional($blog)->id, $header_setting_meta_key);
            $header_setting =   !empty($header_setting)?$header_setting:'theme_default';

            if($header_setting == 'custom'){
                
                $header_style = !empty($page) ? \ThemeOption::GetPageOptionById(optional($page)->id, $header_style_meta_key) : \ThemeOption::GetBlogOptionById(optional($blog)->id, $header_style_meta_key);

                $dzRes['header_style']  = !empty($header_style)?$header_style:$dzRes['header_style'];
            }

            $footer_setting = !empty($page) ? \ThemeOption::GetPageOptionById(optional($page)->id, $footer_setting_meta_key) : \ThemeOption::GetBlogOptionById(optional($blog)->id, $footer_setting_meta_key);
            $footer_setting =   !empty($footer_setting)?$footer_setting:'theme_default';
            

            if($footer_setting == 'custom'){
                
                $footer_style = !empty($page) ? \ThemeOption::GetPageOptionById(optional($page)->id, $footer_style_meta_key) : \ThemeOption::GetBlogOptionById(optional($blog)->id, $footer_style_meta_key);
                $dzRes['footer_on'] = !empty($page) ? \ThemeOption::GetPageOptionById(optional($page)->id, $footer_on_meta_key) : \ThemeOption::GetBlogOptionById(optional($blog)->id, $footer_on_meta_key);

                $dzRes['footer_style']  = !empty($footer_style)?$footer_style:$dzRes['footer_style'];
            }

            /*Page Header: necessary to get here */
            if($viewName == 'page') 
            {
                $page_header_setting    =   \ThemeOption::GetPageOptionById(optional($page)->id, 'page_header_setting');
                $page_header_setting    =   !empty($page_header_setting)?$page_header_setting:'theme_default';

                if($page_header_setting == 'custom'){
                    $page_header_style  = \ThemeOption::GetPageOptionById(optional($page)->id, 'page_header_style'); 
                    $dzRes['header_style']  = !empty($page_header_style)?$page_header_style:$dzRes['header_style'];
                }
            }
            /*Page Header: necessary to get here END */

            $dzRes['header_style_class'] = ($dzRes['header_style'] == 'header_3') ? 'header-transparent' : '';
            $dzRes['header_login_on'] = config('ThemeOptions.header_login_on');

            $dzRes['header_register_on'] = config('ThemeOptions.header_register_on');
            $dzRes['header_sticky_on'] = config('ThemeOptions.header_sticky_on');
            $dzRes['show_website_search'] = config('ThemeOptions.show_website_search',true);
            $dzRes['show_login_registration'] = config('ThemeOptions.show_login_registration');
            $dzRes['show_social_icon'] = config('ThemeOptions.show_social_icon');
            $dzRes['header_sticky_class'] = ($dzRes['header_sticky_on']) ? 'sticky-header' : '';

            $dzRes['site_phone_number'] = config('ThemeOptions.site_phone_number');
            $dzRes['site_email'] = config('ThemeOptions.site_email');
            $dzRes['header_search_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_search_on', true);
            $dzRes['header_search_button_title'] = config('ThemeOptions.'.$dzRes['header_style'].'_search_button_title',__('Search'));
            $dzRes['header_social_link_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_social_link_on');
            $dzRes['header_social_links'] = config('ThemeOptions.'.$dzRes['header_style'].'_social_links');
            $dzRes['header_top_bar_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_top_bar_on');
            $dzRes['header_author_banner_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_author_banner_on');
            $dzRes['header_banner_bg_image'] = config('ThemeOptions.'.$dzRes['header_style'].'_banner_bg_image');
            $dzRes['header_banner_bg_image'] = !empty($dzRes['header_banner_bg_image'])?$dzRes['header_banner_bg_image']:'';

            /* Manage Subscription Form */
            $dzRes['header_subscribe_on'] = config('ThemeOptions.header_subscribe_on');
            $dzRes['header_subscribe_popup_title'] = config('ThemeOptions.header_subscribe_popup_title','Join Us To Day');
            $dzRes['header_subscribe_popup_desc'] = config('ThemeOptions.header_subscribe_popup_desc','Receive Only The Best Posts Via Email');
            /* End Manage Subscription Form */
            
            $header_style_options = function_exists('header_style_options') ? header_style_options() : array();
            foreach($header_style_options as $header)
            {
                $call_to_action_button = $header['param']['call_to_action_button'] ?? 0;

                if($call_to_action_button > 0 )
                {                   
                    for($i = 1; $i <= $call_to_action_button; $i++ )
                    {
                        $dzRes['header_button_'.$i.'_text'] = config('ThemeOptions.'.$dzRes['header_style'].'_button_'.$i.'_text', '');
                        $dzRes['header_button_'.$i.'_url'] = config('ThemeOptions.'.$dzRes['header_style'].'_button_'.$i.'_url', ''); 
                        $dzRes['header_button_'.$i.'_target'] = config('ThemeOptions.'.$dzRes['header_style'].'_button_'.$i.'_target', '');
                    }
                }
            }

            $dzRes['mobile_header_login_on'] = config('ThemeOptions.mobile_header_login_on', '');
            $dzRes['mobile_header_register_on'] = config('ThemeOptions.mobile_header_register_on', '');
            $dzRes['mobile_header_social_link_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_mobile_social_link_on', '');
            $dzRes['mobile_search_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_mobile_search_on', '');

            $dzRes['social_link_target'] = config('ThemeOptions.social_link_target','');
            /* header settings END */

            /* Footer Settings Starts */    
            $dzRes['footer_subscription_section'] = config('ThemeOptions.footer_subscription_section', false);
            $dzRes['subscription_section_image'] = asset('storage/configuration-images/'.config('ThemeOptions.subscription_section_image'));
            $dzRes['subscription_section_title'] = config('ThemeOptions.subscription_section_title',__('Subscribe to My Blog'));
            $dzRes['subscription_section_bg_text'] = config('ThemeOptions.subscription_section_bg_text',__('subscribe'));
            
            $dzRes['footer_top'] = config('ThemeOptions.footer_top', false);
            $dzRes['footer_bg_image'] = config('ThemeOptions.'.$dzRes['footer_style'].'_bg_image','');
            
            /*Footer: necessary to get here */
            if($viewName == 'page') 
            {
                $page_footer_setting = \ThemeOption::GetPageOptionById(optional($page)->id, 'page_footer_setting');
                $page_footer_setting    =   !empty($page_footer_setting)?$page_footer_setting:'theme_default';
                if($page_footer_setting == 'custom'){
                    $page_footer_style  = \ThemeOption::GetPageOptionById(optional($page)->id, 'page_footer_style'); 
                    $dzRes['footer_on']     = \ThemeOption::GetPageOptionById(optional($page)->id, 'page_footer_on');
                    $dzRes['footer_style']  = !empty($page_footer_style)?$page_footer_style:$dzRes['footer_style'];
                }

            }
            /*Footer: necessary to get here END */

            $dzRes['footer_social_on'] = config('ThemeOptions.'.$dzRes['footer_style'].'_social_on');
            $dzRes['footer_copyright_text'] = config('ThemeOptions.footer_copyright_text', LEMARS_COPYWRITE_TEXT);
            
            /* Footer Instagram Settings */
            $dzRes['footer_top_feeds'] = config('ThemeOptions.footer_top_feeds', 'normal_feeds');
            if($dzRes['footer_top_feeds'] == 'instagram_feeds')
            {
                $dzRes['instagram_shortcode']       = config('ThemeOptions.instagram_shortcode');
                $dzRes['footer_instagram_title']    = config('ThemeOptions.footer_instagram_title');
                $dzRes['footer_instagram_link']     = config('ThemeOptions.footer_instagram_link');
                $dzRes['footer_instagram_btn_text'] = config('ThemeOptions.footer_instagram_btn_text');
            }
            
            /* Footer Instagram Settings END */
            
            /* Footer Settings END */

            /* logo setting , adition logo settings for 'site_other_logo' for lemars theme */
            $dzRes['logo_type'] = config('ThemeOptions.logo_type', '');
            $dzRes['logo_title'] = config('ThemeOptions.logo_title', LEMARS_DEFAULT_TEXT_LOGO);
            $dzRes['logo_tag'] = config('ThemeOptions.logo_tag', LEMARS_DEFAULT_TAG);
            
            $dzRes['logo_alt'] = config('ThemeOptions.logo_alt', LEMARS_DEFAULT_TEXT_LOGO);
            
            if(!empty(config('ThemeOptions.logo_type')) && config('ThemeOptions.logo_type') == 'image_logo')
            {
                $dzRes['logo'] = ($dzRes['header_style'] == 'header_2') ? config('ThemeOptions.site_other_logo', LEMARS_DEFAULT_WHITE_LOGO) : config('ThemeOptions.site_logo', LEMARS_DEFAULT_LOGO);
            }
            elseif(!empty(config('ThemeOptions.logo_type')) && config('ThemeOptions.logo_type') == 'text_logo') {
                $dzRes['logo_text'] = config('ThemeOptions.logo_text' , LEMARS_DEFAULT_TEXT_LOGO);
                $dzRes['logo_title'] = config('ThemeOptions.logo_title', LEMARS_DEFAULT_TEXT_LOGO);
            }
            else {
                $dzRes['logo'] = LEMARS_DEFAULT_LOGO;
            }

            $dzRes['site_logo'] = !empty(config('ThemeOptions.site_logo')) ? config('ThemeOptions.site_logo', LEMARS_DEFAULT_LOGO) : LEMARS_DEFAULT_LOGO;

            $dzRes['site_other_logo'] = !empty(config('ThemeOptions.site_other_logo')) ? config('ThemeOptions.site_other_logo', LEMARS_DEFAULT_WHITE_LOGO) : LEMARS_DEFAULT_WHITE_LOGO;

            $dzRes['ratina_logo'] = !empty(config('ThemeOptions.ratina_logo')) ? config('ThemeOptions.ratina_logo' , '') : '';
            $dzRes['mobile_logo'] = !empty(config('ThemeOptions.mobile_logo')) ? config('ThemeOptions.mobile_logo', '') : '';
            $dzRes['ratina_mobile logo'] = !empty(config('ThemeOptions.ratina_mobile_logo')) ? config('ThemeOptions.ratina_mobile_logo', '') : '';
            /* End logo setting  */

            /*************************************************************************************************/
            $dzRes['show_search_button'] = $dzRes['header_search_on'];
            $dzRes['search_button_title'] = $dzRes['header_search_button_title'];
            $dzRes['hide_social_icons_mobile'] = $dzRes['mobile_header_social_link_on'];

            /* Post general setting */
            $dzRes['post_layout'] = config('ThemeOptions.post_general_layout', 'standard');
            $dzRes['post_view_on'] = config('ThemeOptions.post_view_on');
            $dzRes['post_start_view'] = config('ThemeOptions.post_start_view', 1);
            $dzRes['pre_next_post_on'] = config('ThemeOptions.pre_next_post_on');
            $dzRes['comment_view_on'] = config('ThemeOptions.comment_view_on');
            $dzRes['featured_img_on'] = config('ThemeOptions.featured_img_on');
            $dzRes['featured_img_on'] = config('ThemeOptions.featured_img_on');
            /* Post general setting end */
            
            /* Page banner setting */
            $dzRes['show_banner'] = !empty(config('ThemeOptions.page_general_banner_on')) ? config('ThemeOptions.page_general_banner_on') : true;
            $dzRes['banner_type'] = 'image';
            $dzRes['banner_height'] = config('ThemeOptions.page_general_banner_height', 'page_banner_big');
            $dzRes['banner_custom_height'] = config('ThemeOptions.page_general_banner_custom_height', '100');
            $dzRes['banner_image'] = !empty(config('ThemeOptions.page_general_banner')) ? config('ThemeOptions.page_general_banner', LEMARS_BANNER) : LEMARS_BANNER;
            /* End Page banner setting */
            
            /* Sidebar and there layout */
            $dzRes['layout'] = 'right';
            $dzRes['sidebar'] = 'dz_default_sidebar';
            $dzRes['show_sidebar'] = config('ThemeOptions.page_general_show_sidebar', true);
            if($dzRes['show_sidebar']) {
                $dzRes['layout'] = config('ThemeOptions.page_general_sidebar_layout', 'right');
                $dzRes['sidebar'] = config('ThemeOptions.page_general_sidebar', 'dz_default_sidebar');
            }
            /* End Sidebar and there layout */

            $pagination = config('ThemeOptions.page_general_paging', 'default');
            $dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
            /*************************************************************************************************/

            $HomePagetemp = $dzRes;
            
            /* page.php */
            if($viewName == 'page') {
            
                $page_level_keys = array(
                    'page_header_setting',
                    'page_header_style',
                    'page_banner_height',
                    'page_banner_on',
                    'page_banner_hide',
                    'page_banner',
                    'banner_image',
                    'page_show_sidebar',
                    'page_sidebar_layout',
                    'page_sidebar',
                    'page_footer_setting',
                    'page_footer_style',
                );

                foreach($page_level_keys as $value)
                {
                    $page_settings[$value] =  \ThemeOption::GetPageOptionById(optional($page)->id, $value);
                }
                /* Header & Logo Setting */
                $page_header_setting    =   !empty($page_settings['page_header_setting'])?$page_settings['page_header_setting']:'theme_default';
                if($page_header_setting == 'custom'){
                    $dzRes['header_style'] = !empty($page_settings['page_header_style'])?$page_settings['page_header_style']:$dzRes['header_style'];
                }
                
                $dzRes['header_top_bar_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_top_bar_on');
                $dzRes['header_search_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_search_on',true);        
                $dzRes['header_search_on'] = config('ThemeOptions.'.$dzRes['header_style'].'_search_button_title',true);        
                $dzRes['header_style_class'] = ($dzRes['header_style'] == 'header_2') ? 'header-transparent' : '';

                if($dzRes['header_style'] == 'header_2')
                {
                    $dzRes['logo'] = config('ThemeOptions.site_other_logo');
                    $dzRes['logo'] = $dzRes['logo'] ?? LEMARS_DEFAULT_WHITE_LOGO;
                }else{
                    $dzRes['logo'] = config('ThemeOptions.site_logo');
                    $dzRes['logo'] = $dzRes['logo'] ?? LEMARS_DEFAULT_LOGO;
                }
                /* End Header & Logo Setting */
                
                /* Page banner setting */
                $dzRes['show_banner'] = isset($page_settings['page_banner_on']) ? $page_settings['page_banner_on'] : $dzRes['show_banner'];
                
                $dzRes['banner_height'] = !empty($page_settings['page_banner_height'])?$page_settings['page_banner_height']:$dzRes['banner_height'];
                
                $dzRes['banner_custom_height'] = !empty($page_settings['page_banner_custom_height'])?$page_settings['page_banner_custom_height']:$dzRes['banner_custom_height'];
                
                $dzRes['dont_use_banner_image'] = $page_settings['page_banner_hide'] ?? 0;
                
                if($dzRes['dont_use_banner_image'] == 0){
                    $dzRes['banner_image'] = isset($page_settings['page_general_banner']) ? $page_settings['page_general_banner'] ?? $dzRes['banner_image'] : $dzRes['banner_image']; 
                }
                else{
                    $dzRes['banner_image'] = "";
                }
                /* End page banner setting */
                
                /* Sidebar and there layout */
                $dzRes['show_sidebar'] = isset($page_settings['page_show_sidebar']) ? $page_settings['page_show_sidebar'] : $dzRes['show_sidebar'];
                if($dzRes['show_sidebar']) {
                    $dzRes['layout'] = $page_settings['page_sidebar_layout'] ?? $dzRes['layout'];
                    $dzRes['sidebar'] = $page_settings['page_sidebar'] ?? $dzRes['sidebar'];
                }
                /* End Sidebar and there layout */

                $page_footer_setting    =   !empty($page_settings['page_footer_setting'])?$page_settings['page_footer_setting']:'theme_default';
                if($page_footer_setting == 'custom'){
                    $dzRes['footer_style'] = !empty($page_settings['page_footer_style'])?$page_settings['page_footer_style']:$dzRes['footer_style'];
                }
                
            }

            /* single.php */
            if($viewName == 'single') {

                $page_level_keys = array(
                    'featured_post',
                    'post_layout',
                    'post_type_gallery1',
                    'post_type_gallery2',
                    'post_type_link',
                    'post_type_video',
                    'post_type_audio',
                    'post_show_sidebar',
                    'post_sidebar_layout',
                    'post_sidebar'
                );
                foreach($page_level_keys as $value)
                {
                    $page_settings[$value] =  \ThemeOption::GetBlogOptionById(optional($blog)->id, $value);
                }

                $testStr .= "This is single page---";

                $dzRes['is_featured_post'] = \ThemeOption::GetBlogOptionById(optional($blog)->id, 'featured_post');
                $post_layout = \ThemeOption::GetBlogOptionById(optional($blog)->id, 'post_layout');
                $dzRes['post_layout'] = (isset($post_layout)) ? $post_layout : $dzRes['post_layout'];

                if($dzRes['post_layout'] == 'slider_post_1') {
                    $dzRes['post_gallary_setting'] = \ThemeOption::GetBlogOptionById(optional($blog)->id, 'post_type_gallery1');
                }
                if($dzRes['post_layout'] == 'slider_post_2') {
                    $dzRes['post_gallary_setting'] = \ThemeOption::GetBlogOptionById(optional($blog)->id, 'post_type_gallery2');
                }

                $dzRes['external_link'] = \ThemeOption::GetBlogOptionById(optional($blog)->id, 'post_type_link');
                $dzRes['youtube_link'] = \ThemeOption::GetBlogOptionById(optional($blog)->id, 'post_type_video');
                $dzRes['audio_link'] = \ThemeOption::GetBlogOptionById(optional($blog)->id, 'post_type_audio');
                
                // Single post sidebar settings from post level.
                if($dzRes['post_layout'] == 'gutenberg') {
                    $dzRes['sidebar'] = '';
                    $dzRes['layout'] = 'full';
                }
                else {

                    /* Sidebar and there layout */
                    $dzRes['show_sidebar'] = $page_settings['post_show_sidebar'] ?? $dzRes['show_sidebar'];
                    
                    if($dzRes['show_sidebar'] == true) {
                        $dzRes['layout'] = $page_settings['post_sidebar_layout'] ?? $dzRes['layout'];
                        $dzRes['sidebar'] = $page_settings['post_sidebar'] ?? $dzRes['sidebar'];
                    }
                    /* End Sidebar and there layout */
                }
                // Single post sidebar settings from post level end.
                $dzRes['related_post_title'] = config('ThemeOptions.related_post_title', '');
                $dzRes['layout_class'] = ($dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';
            }

            /* archive.php */
            if($viewName == 'archive') {

                $testStr .= "This is archive page---";
                $dzRes['page_title'] = config('ThemeOptions.archive_page_title', __('Archive : '));
                
                /* Page banner setting */
                $dzRes['show_banner'] = !empty(config('ThemeOptions.archive_page_banner_on')) ? config('ThemeOptions.archive_page_banner_on') : $dzRes['show_banner'];

                $dzRes['banner_height'] = config('ThemeOptions.archive_page_banner_height', $dzRes['banner_height']);
                $dzRes['dont_use_banner_image'] = config('ThemeOptions.archive_page_banner_hide', '0');
                
                $dzRes['banner_custom_height'] = config('ThemeOptions.archive_page_banner_custom_height', $dzRes['banner_custom_height']);

                if($dzRes['dont_use_banner_image'] == 0){
                    $dzRes['banner_image'] = !empty(config('ThemeOptions.archive_page_banner')) ? config('ThemeOptions.archive_page_banner', $dzRes['banner_image']) : $dzRes['banner_image'];
                }
                else{
                    $dzRes['banner_image'] = "";
                }
                /* End Page banner setting */
                        
                /* Sidebar and there layout */
                $dzRes['show_sidebar'] = !empty(config('ThemeOptions.archive_page_show_sidebar')) ? config('ThemeOptions.archive_page_show_sidebar') : true;
                if($dzRes['show_sidebar']) {
                    $dzRes['layout'] = config('ThemeOptions.archive_page_sidebar_layout', $dzRes['layout']);
                    $dzRes['sidebar'] = config('ThemeOptions.archive_page_sidebar', $dzRes['sidebar']);
                }
                /* End Sidebar and there layout */

                $pagination = config('ThemeOptions.archive_page_paging', $dzRes['disable_ajax_pagination']);
                $dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
            }

            /* tag.php */
            if($viewName == 'tag') {

                $testStr .= "This is tag page---";
                $dzRes['page_title'] = config('ThemeOptions.tag_page_title', __('Tag : '));

                /* Tag banner setting */
                $dzRes['show_banner'] = !empty(config('ThemeOptions.tag_page_banner_on')) ? config('ThemeOptions.tag_page_banner_on') : $dzRes['show_banner'];
                $dzRes['banner_height'] = config('ThemeOptions.tag_page_banner_height', $dzRes['banner_height']);
                $dzRes['dont_use_banner_image'] = config('ThemeOptions.tag_page_banner_hide', '0');
                
                $dzRes['banner_custom_height'] = config('ThemeOptions.tag_page_banner_custom_height', $dzRes['banner_custom_height']);

                if($dzRes['dont_use_banner_image'] == 0){
                    $dzRes['banner_image'] = !empty(config('ThemeOptions.tag_page_banner')) ? config('ThemeOptions.tag_page_banner', $dzRes['banner_image']) : $dzRes['banner_image'];
                }
                else{
                    $dzRes['banner_image'] = "";
                }
                /* End Tag banner setting */
                
                /* Sidebar and there layout */
                $dzRes['show_sidebar'] = !empty(config('ThemeOptions.tag_page_show_sidebar')) ? config('ThemeOptions.tag_page_show_sidebar') : true;
                if($dzRes['show_sidebar']) {
                    $dzRes['layout'] = config('ThemeOptions.tag_page_sidebar_layout', $dzRes['layout']);
                    $dzRes['sidebar'] = config('ThemeOptions.tag_page_sidebar', $dzRes['sidebar']);
                }
                /* End Sidebar and there layout */

                $pagination = config('ThemeOptions.tag_page_paging', $dzRes['disable_ajax_pagination']);
                $dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
            }

            /* author.php */
            if($viewName == 'author') {

                $testStr .= "This is Author page";
                $dzRes['page_title'] = config('ThemeOptions.author_page_title', __('Author : '));
                $dzRes['page_title'] = $dzRes['page_title'] . optional($user)->full_name;
                /* Tag banner setting */

                $dzRes['show_banner'] = !empty(config('ThemeOptions.author_page_banner_on')) ? config('ThemeOptions.author_page_banner_on') : $dzRes['show_banner'];

                $dzRes['banner_height'] = config('ThemeOptions.author_page_banner_height', $dzRes['banner_height']);
                $dzRes['dont_use_banner_image'] = config('ThemeOptions.author_page_banner_hide', '0');
                
                $dzRes['banner_custom_height'] = config('ThemeOptions.author_page_banner_custom_height', $dzRes['banner_custom_height']);

                if($dzRes['dont_use_banner_image'] == 0){   
                    $dzRes['banner_image'] = !empty(config('ThemeOptions.author_page_banner')) ? config('ThemeOptions.author_page_banner', $dzRes['banner_image']) : $dzRes['banner_image'];
                }
                else{
                    $dzRes['banner_image'] = "";
                }
                /* End Tag banner setting */
                
                $dzRes['show_banner'] = config('ThemeOptions.author_page_banner_on', $dzRes['show_banner']);
                if($dzRes['show_banner'] == true) {
                    $dzRes['banner_height'] = config('ThemeOptions.author_page_banner_height', $dzRes['banner_height']);
                    $dzRes['banner_image'] = config('ThemeOptions.author_page_banner', $dzRes['banner_image']);
                    $dzRes['dont_use_banner_image'] = config('ThemeOptions.author_page_banner_hide', '0');
                }

                /* Sidebar and there layout */
                $dzRes['show_sidebar'] = empty(config('ThemeOptions.author_page_show_sidebar')) ? config('ThemeOptions.author_page_show_sidebar') : true;
                if($dzRes['show_sidebar']) {
                    $dzRes['layout'] = config('ThemeOptions.author_page_sidebar_layout', $dzRes['layout']);
                    $dzRes['sidebar'] = config('ThemeOptions.author_page_sidebar', $dzRes['sidebar']);
                }
                /* End Sidebar and there layout */

                $pagination = config('ThemeOptions.author_page_paging', $dzRes['disable_ajax_pagination']);
                $dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
            }

            /* index.php */
            if($viewName == 'index') {
                
                $dzRes['page_title'] = config('ThemeOptions.blog_page_title', __('Lemars Personal Blog'));
            }
            
            /* search.php */
            if($viewName == 'search') {

                $testStr .= "This is Search Page";
                $dzRes['page_title'] = config('ThemeOptions.search_page_title', __('Search : '));

                /* Search banner setting */
                $dzRes['show_banner'] = !empty(config('ThemeOptions.search_page_banner_on')) ? config('ThemeOptions.search_page_banner_on') : $dzRes['show_banner'];
                $dzRes['banner_height'] = config('ThemeOptions.search_page_banner_height', $dzRes['banner_height']);
                $dzRes['dont_use_banner_image'] = config('ThemeOptions.search_page_banner_hide', '0');
                
                $dzRes['banner_custom_height'] = config('ThemeOptions.search_page_banner_custom_height', $dzRes['banner_custom_height']);

                if($dzRes['dont_use_banner_image'] == 0){
                    $dzRes['banner_image'] = !empty(config('ThemeOptions.search_page_banner')) ? config('ThemeOptions.search_page_banner', $dzRes['banner_image']) : $dzRes['banner_image'];
                }
                else{
                    $dzRes['banner_image'] = "";
                }
                /* End Search banner setting */

                /* Sidebar and there layout */
                $dzRes['show_sidebar'] = !empty(config('ThemeOptions.search_page_show_sidebar')) ? config('ThemeOptions.search_page_show_sidebar') : true;
                if($dzRes['show_sidebar']) {
                    $dzRes['layout'] = config('ThemeOptions.search_page_sidebar_layout', $dzRes['layout']);
                    $dzRes['sidebar'] = config('ThemeOptions.search_page_sidebar', $dzRes['sidebar']);
                }
                /* End Sidebar and there layout */

                $pagination = config('ThemeOptions.search_page_paging', $dzRes['disable_ajax_pagination']);
                $dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
            }

            if($viewName == 'page' || $viewName == 'archive' || $viewName == 'tag' || $viewName == 'author' || $viewName == 'index' || $viewName == 'search' || $viewName == '404') {

                $dzRes['banner_class'] = '';
                if($dzRes['header_style'] == 'header_2')
                {
                    $dzRes['banner_class'] .= ' tp-banner';
                }
                
                if(isset($dzRes['banner_height']) && $dzRes['banner_height'] == 'page_banner_big') {
                    $dzRes['banner_class'] .= 'dlab-bnr-inr-md';
                }elseif(isset($dzRes['banner_height']) && $dzRes['banner_height'] == 'page_banner_medium'){
                    $dzRes['banner_class'] .= 'dlab-bnr-inr-sm';
                }
                
                $dzRes['page_banner_style_attr'] = !empty($dzRes['banner_image']) ? 'background-image:url('.$dzRes['banner_image'].')' : '';
                
                $dzRes['container_class'] = ($dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true) ? 'min-container' : 'container';
                $dzRes['layout_class'] = ($dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true  ) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';
                
            }

            /* category.php */
            if($viewName == 'category') {

                $testStr .= "This is Category page";
                $dzRes['banner_height'] = '';
                $dzRes['dont_use_banner_image'] = 0;
                $dzRes['page_title'] = config('ThemeOptions.category_page_title', __('Category : '));
                    
                /* Search banner setting */
                $dzRes['show_banner'] = !empty(config('ThemeOptions.category_page_banner_on')) ? config('ThemeOptions.category_page_banner_on') : $dzRes['show_banner'];
                $dzRes['banner_height'] = config('ThemeOptions.category_page_banner_height', $dzRes['banner_height']);
                $dzRes['dont_use_banner_image'] = config('ThemeOptions.category_page_banner_hide', '0');
                
                $dzRes['banner_custom_height'] = config('ThemeOptions.category_page_banner_custom_height', $dzRes['banner_custom_height']);

                if($dzRes['dont_use_banner_image'] == 0){   
                    $dzRes['banner_image'] = !empty(config('ThemeOptions.category_page_banner')) ? config('ThemeOptions.category_page_banner', $dzRes['banner_image']) : $dzRes['banner_image'];
                }
                else{
                    $dzRes['banner_image'] = "";
                }
                /* End Search banner setting */
                        
                /* Sidebar and there layout */
                $dzRes['show_sidebar'] = !empty(config('ThemeOptions.category_page_show_sidebar')) ? config('ThemeOptions.category_page_show_sidebar') : true;
                if($dzRes['show_sidebar']) {
                    $dzRes['layout'] = config('ThemeOptions.category_page_sidebar_layout', $dzRes['layout']);
                    $dzRes['sidebar'] = config('ThemeOptions.category_page_sidebar', $dzRes['sidebar']);
                }
                /* End Sidebar and there layout */

                /* To manage Category Page banner and layout settings */
                $dzRes['banner_class'] = '';
                if($dzRes['header_style'] == 'header_2')
                {
                    $dzRes['banner_class'] .= ' tp-banner';
                }
                
                if(isset($dzRes['banner_height']) && $dzRes['banner_height'] == 'page_banner_big') {
                    $dzRes['banner_class'] .= 'dlab-bnr-inr-md';
                }elseif(isset($dzRes['banner_height']) && $dzRes['banner_height'] == 'page_banner_medium'){
                    $dzRes['banner_class'] .= 'dlab-bnr-inr-sm';
                }
                
                $dzRes['page_banner_style_attr'] = !empty($dzRes['banner_image']) ? 'background-image:url('.$dzRes['banner_image'].')' : '';
                $dzRes['container_class'] = ($dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true) ? 'min-container' : 'container';
                $dzRes['layout_class'] = ($dzRes['layout'] == 'full' || $dzRes['show_sidebar'] != true ) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';
                /* End To manage Category Page banner and layout settings */

                $pagination = config('ThemeOptions.category_page_paging', $dzRes['disable_ajax_pagination']);
                $dzRes['disable_ajax_pagination'] = ($pagination == 'load_more') ? $pagination : '';
                /* all other variable will manage on category page from db. */
            }

            if($viewName == '404'){
                $dzRes['error_page_title'] = config('ThemeOptions.error_page_title', __('404'));
                $dzRes['error_page_text'] = config('ThemeOptions.error_page_text', __('We are sorry. But the page you are looking for cannot be found.'));
                $dzRes['error_page_button_text'] = config('ThemeOptions.error_page_button_text', __('Back to Home'));
            }

            //* Logo Setting According To Theme Color and Header *//

            $dzRes['predefined_color_skin'] = config('ThemeOptions.predefined_color_skin', 'black-blue-default');
            $dzRes['header_logo'] =  $dzRes['site_logo'];
            $dzRes['footer_logo'] = $dzRes['site_other_logo'];
            $dzRes['loading_logo'] = $dzRes['site_logo'];
            if(in_array($dzRes['predefined_color_skin'], array('black-blue-default','blue-white-dark','orange-white-dark', 'black-white-dark')))
            {
                $dzRes['loading_logo'] = $dzRes['site_other_logo'];
            }
            
            if(in_array($dzRes['header_style'], array('header_7')))
            {
                $dzRes['header_logo'] = $dzRes['footer_logo'] = $dzRes['site_logo'];
                if(in_array($dzRes['predefined_color_skin'], array('black-blue-default','blue-white-dark','orange-white-dark', 'black-white-dark')))
                {
                    $dzRes['footer_logo'] = $dzRes['site_other_logo'];
                    
                }
            }   
            elseif(in_array($dzRes['header_style'], array('header_5')))
            {
                $dzRes['header_logo'] = $dzRes['footer_logo'] = $dzRes['site_other_logo'];
                if(in_array($dzRes['predefined_color_skin'], array('blue-white-light-2', 'orange-white-light', 'black-white-light')))
                {
                    $dzRes['footer_logo'] = $dzRes['site_logo'];
                }
            }   
            elseif(in_array($dzRes['header_style'], array('header_3')))
            {
                $dzRes['header_logo'] = $dzRes['footer_logo'] = $dzRes['site_other_logo'];
                if(in_array($dzRes['predefined_color_skin'], array('blue-white-light-2', 'orange-white-light', 'black-white-light')))
                {
                    $dzRes['footer_logo'] = $dzRes['site_logo'];
                }
            }
            elseif(
                in_array($dzRes['header_style'], array('header_1', 'header_2','header_4','header_6','header_8')) && 
                in_array($dzRes['predefined_color_skin'], array('black-blue-default', 'blue-white-light-2', 'orange-white-light', 'black-white-light')) 
                )
                {
                    $dzRes['header_logo'] = $dzRes['footer_logo'] = $dzRes['site_logo'];
                    
                    if(in_array($dzRes['predefined_color_skin'], array('black-blue-default')))
                    {
                        $dzRes['footer_logo'] = $dzRes['site_other_logo'];
                    }   
                }
            elseif(
                in_array($dzRes['header_style'], array('header_1', 'header_2','header_4','header_6','header_8')) && 
                in_array($dzRes['predefined_color_skin'], array('blue-white-dark','orange-white-dark', 'black-white-dark')) 
                )
                {
                    $dzRes['header_logo'] = $dzRes['footer_logo'] = $dzRes['site_other_logo'];
                }

            $mobile_header_login_on     = ($dzRes['mobile_header_login_on'])?'Yes':'No';
            $mobile_header_register_on  = ($dzRes['mobile_header_register_on'])?'Yes':'No';
            $mobile_header_social_link_on   = ($dzRes['mobile_header_social_link_on'])?'Yes':'No';

            $dzRes['js_data'] = array(    
                'template_directory_uri' => theme_asset('/'),
                'login_on_mobile' => $mobile_header_login_on,
                'register_on_mobile'=>$mobile_header_register_on,   
                'header_social_link_on_mobile'=>$mobile_header_social_link_on, 
            );

            
            /*  Set All Option Values to lemars_option Variable 
            *   and get it in every view of front to extract the dzRes array.
            */
            $lemars_option = $dzRes;

            $view->with('lemars_option', $lemars_option);

        }

    }
}
