@php
	$options_type = isset($options_type) ? $options_type : '';
	$options_data = isset($options_data) ? $options_data : array();
	$dropdownStart = false;
@endphp
<div class="d-flex">
    <ul class="ThemeOptionsMainMenu nav flex-column" role="tablist" aria-orientation="vertical">
        @forelse ($sections as $key => $section)
        	
        	@php
        		$section_key = (!empty($sections[$key+1]['subsection']) && $sections[$key+1]['subsection'] == true && empty($section['subsection']))  ? $key + 2 : $key + 1;
        		$hasSubSectionClass = (!empty($sections[$key+1]['subsection']) && $sections[$key+1]['subsection'] == true && empty($section['subsection'])) ? 'has-subsection' : '';
        	@endphp


        	@if ($dropdownStart && empty($section['subsection']))
        		@php
					$dropdownStart = false;
				@endphp
	            	</ul>
	            </li>
        	@endif

        	@if (empty($section['subsection']) && empty($hasSubSectionClass))
	        	<li class="nav-item ">
	                <a class="nav-link text-nowrap {{ $key == 0 ? 'active' : '' }}" data-bs-toggle="tab" href="#section_group_{{$section_key}}">
	                	<i class="me-2 {{ !empty($section['icon']) ? $section['icon'] : 'fa-home' }}"></i>
	                	<span> {{ $section['title'] }}</span>
	            	</a>
	            </li>
            @else
	        	
	        	@if (empty($section['subsection']))
					@php
						$dropdownStart = true;
					@endphp

		        	<li class="nav-item {{ $hasSubSectionClass }} ">
		                <a class="nav-link text-nowrap {{ $key == 0 ? 'active' : '' }}" data-bs-toggle="tab" href="#section_group_{{$section_key}}">
		                	<i class="me-2 {{ !empty($section['icon']) ? $section['icon'] : 'fa-home' }}"></i>
		                	<span> {{ $section['title'] }}</span>
		            	</a>
		            	<ul class="ThemeOptionsSubMenu" style="display: none;">
            	@endif
	            
	            @if(!empty($section['subsection']) && $section['subsection'] == true)
		            <li class="nav-item subsection">
		                <a class="nav-link text-nowrap {{ $key == 0 ? 'active' : '' }}" data-bs-toggle="tab" href="#section_group_{{$section_key}}">
		                	<i class="me-2 {{ !empty($section['icon']) ? $section['icon'] : 'fa-home' }}"></i>
		                	 <span>{{ $section['title'] }}</span>
		            	</a>
		            </li>
	        	@endif



        	@endif



        @empty
        @endforelse

        @if ($dropdownStart)
            	</ul>
            </li>
    	@endif
        
    </ul>
    <div class="tab-content">
    	@forelse ($sections as $key => $section)
        	@php
        		// dump($section);
        		$check_section = false;
        		$active_section_indent = false;
        	@endphp
        	@if (!empty($section['fields']))
	    	<div class="tab-pane fade {{ $key == 0 ? 'active show' : '' }}" id="section_group_{{$key+1}}" role="tabpanel">
	    		@if (!empty($section['title']) || !empty($section['desc']))
	    		<div class=" mb-4">
					@if (!empty($section['title']))
						<h4 class="card-title">{{$section['title']}}</h4>
					@endif
					@if (!empty($section['desc']))
					<p>{{$section['desc']}}</p>
					@endif
				</div>
	    		@endif
	    		<div class="pt-4">
	    			@if (!empty($section['fields']))
						@forelse ($section['fields'] as $field)
							@php
								$depend_on = '';
								$datafield = '';
								if (!empty($options_data) && isset($options_data[$field['id']])) {
						            $field['old_field_value'] = $options_data[$field['id']];
						        }

						        if(isset($field['depend_on'])) 
								{
									if (is_array($field['depend_on']) && !empty($field['depend_on']))
									{
										foreach($field['depend_on'] as $field_name => $field_array)
										{
											// $depend_on .= $field_name.'::'.$field_array['value'].'-depend d-none';
											$depend_on .= $field_name.'-depend d-none';
											if (!is_array($field_array['value'])) {
												$datafield .= "data-".$field_name."-value =".$field_array['value']." ";
											}else{
												$datafield .= "data-".$field_name."-value =".(implode(',', $field_array['value']))." ";
											}
											$datafield .= "data-".$field_name."-operator = ".$field_array['operator']." ";
										}
									}
									else {
										$depend_on = $value['depend_on'].'-depend d-none';
									}
								}

								$fieldClass	 		= !empty($field['class']) 		? $field['class'] 	: '';
								$fieldClass	    	.= isset($field['depend_on']) && !empty($field['depend_on']) ? ' hidden' : '';
								$fieldHeading	 	= !empty($field['title']) && !is_array($field['title']) 		? $field['title'] 	: '';
								$fieldSubtitle	 	= isset($field['subtitle']) 	? $field['subtitle'] : '';
								$fieldDescription 	= isset($field['desc']) 		? $field['desc'] 	: '';
								$hintTitle 			= !empty($field['hint']['title']) 	? $field['hint']['title'] 	: '';
								$hintContent		= !empty($field['hint']['content']) ? $field['hint']['content'] 	: 'Content';
								$field_style 		= !empty($field['style']) 			? $field['style'] : '';
							@endphp
							{{-- info-types:normal,info,warning,success,critical,custom --}}
							@if (in_array($field['type'], array('info','section')))
								@if ($field['type'] == 'info')

									<div class="alert alert-{{ $field_style }} alert-dismissible alert-alt fade show">
	                                    {{-- <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"></button> --}}
	                                    <strong>
	                                    	@if (!empty($field['icon']))
	                                    	<i class="{{$field['icon']}}"></i>
	                                    	@endif
	                                    	{{$field['title']}}
	                                    </strong> {{$fieldDescription}}
	                                </div>
								@elseif ($field['type'] == 'section')
									@if ($check_section == false)
	                        			<div class="pt-3 mb-4 border-bottom border-primary">
	                        				<h5 class="text-primary">{{$fieldHeading}}</h5>
	                        				<p>{{$fieldDescription}}</p>
	                        			</div>
	                    			@else
	                    				<div class="pt-3 mb-4 border-bottom border-primary"></div>
									@endif
									@php
										$check_section = ($check_section == false) ? true : false ;
										$active_section_indent = isset($field['indent']) ? $field['indent'] : true ;
									@endphp
								@endif
								
							@else
	            				{{-- <div class="row mb-2" {{ $fieldClass }}> --}}
	            				<div class="row theme-options-row {{ $active_section_indent ? 'indented-section' : '' }} {{ $depend_on }}" {{ $datafield }} >

									<div class="col-lg-4  mb-lg-0 mb-3">
										<div class="d-flex justify-content-between align-items-center">
											<h6 class="dz-title"> {{$fieldHeading}} </h6>
											@if (!empty($field['hint']))
											<div class="bootstrap-popover d-inline-block">
												<a href="javascript: void(0);" class="text-primary" data-bs-container="body" data-bs-toggle="popover" data-bs-html="true" data-bs-placement="right" data-bs-content="{!! $hintContent !!}" title="{{ $hintTitle }}"><i class="fas fa-question-circle"></i></a>
											</div>
											@endif
										</div>

										<small>{{$fieldSubtitle}}</small>
									</div>
									<div class="col-lg-8">
	                                	
										{!! ThemeOption::CreateField($field,$options_type) !!}
												
										@if($fieldDescription)
											<small class="d-block">{{ $fieldDescription }}</small>
										@endif
									</div>
								</div>

							@endif
						@empty
	            		@endforelse

	    			@endif
				</div>
	    	</div>
	    	@endif
        @empty
        @endforelse
    </div>
</div>
					

@push('inline-scripts')
    <link href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css" rel="stylesheet" type="text/css"/>
	<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>

	<script>


		function addMoreGroupedSection(key=0,thisElement=null) {	
			if (thisElement) {
				var container = jQuery(thisElement).parent('#W3OptionsGroupedSectionWapper').find('.W3OptionsGroupedSection:first');
			}else {
				var container = jQuery('.W3OptionsGroupedSection:first');
			}
			var form = container.clone().appendTo('#W3OptionsGroupedSectionWapper').show();

			container.hide();
			form.find("input").val("");
			form.find("textarea").val("");
			form = container.html();
			
			form = form.replace(/%KEY%/g, key);
			form = form.replace(/data-bsx/g,'data-bs');
			if (thisElement) {
				jQuery(thisElement).parent('#W3OptionsGroupedSectionWapper').find('.W3OptionsGroupedSection:last').html(form);
			}else {
				jQuery('.W3OptionsGroupedSection:last').html(form);
			}

		}

		function addMoreGroupedSectionClick()
		{
			jQuery('.addMoreGroupedSection').on('click', function() {
				var sectionLength = jQuery(this).parent('#W3OptionsGroupedSectionWapper').find('.W3OptionsGroupedSection').length - 1;
				
				addMoreGroupedSection(sectionLength,this);
				jQuery(this).parent('#W3OptionsGroupedSectionWapper').append(this);
			});

			// for first time after page load append btn to last
			jQuery('.addMoreGroupedSection').each(function() {
				jQuery(this).parent('#W3OptionsGroupedSectionWapper').append(this);
			});
		}

		if (jQuery('.W3OptionsGroupedSection').length > 0) {
			addMoreGroupedSection();
			addMoreGroupedSectionClick();
		}

		if (jQuery('.theme-option-btn-set').length > 0) {
			jQuery('.theme-option-btn-set .btn').on('click', function () {
				jQuery(this).parent('.theme-option-btn-set').find('.btn').removeClass('active');
				jQuery(this).addClass('active');
			});
		}
		
		if (jQuery('.theme-option-btn-set-multi').length > 0) {
			jQuery('.theme-option-btn-set-multi .btn').on('click', function () {
				// jQuery(this).parent('.theme-option-btn-set').find('.btn').removeClass('active');
				jQuery(this).toggleClass('active');
			});
		}

		if (jQuery('.SelectImageContainer').length > 0) {
			jQuery('.SelectImageContainer select').on('change', function () {
				var img = jQuery(this).val();
				jQuery(this).parents('.SelectImageContainer').find('img').attr('src',img);

			});
		}

		if (jQuery('.ThemeOptionsEditor').length > 0) {
			let editorOptions = {
				removePlugins: 'cloudservices, easyimage, exportpdf',
				disallowedContent: 'script; *[on*]',
				extraPlugins: 'uploadimage,image',
				autoParagraph: false,
				enterMode: CKEDITOR.ENTER_BR,
				fillEmptyBlocks: false,
				clipboard_handleImages: false,
				allowedContent: true,
				extraAllowedContent: '*(*)',
				filebrowserUploadUrl: baseUrl + '/ckeditor/uploads?_token=' + csrf_token,
				filebrowserUploadMethod: 'form',
				toolbar: [
					{ items: ['Source', '-', 'Image', 'SelectAll', 'TextColor', 'BGColor', 'Bold', 'Italic', 'Underline', 'Strike', 'Subscript', 'Superscript', '-', 'Undo', 'Redo', '-', 'Find', '-', 'NumberedList', 'BulletedList', '-', 'Outdent', 'Indent', '-'] },
					{ items: [, 'BidiLtr', 'BidiRtl', 'Link', 'Unlink', 'Table', 'HorizontalRule', 'SpecialChar'] },
					'/',
					{ name: 'styles', items: ['Styles', 'Format', 'Font', 'FontSize', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock', '-', 'Blockquote', 'CreateDiv'] },
					{ name: 'colors', items: [] },
				],
			};

			jQuery(".ThemeOptionsEditor").each(function () {
				CKEDITOR.replace($(this).attr('id'), editorOptions);
				if (jQuery('body[data-theme-version="dark"]').length > 0) {
					CKEDITOR.addCss('.cke_editable { background-color: #000; color: #fff }');
				}
			});
		}

		if (jQuery('.ThemeOptionsSpinner').length > 0) {
			$(".ThemeOptionsSpinner").each(function() {
		    	var spinnerOptions = [];
		    	var min = $(this).data("min");
		    	var max = $(this).data("max");
		    	var step = $(this).data("step");

			    if (typeof(min) != "undefined" && min !== null) {
			    	spinnerOptions['min'] = min;
			    }
			    if (typeof(max) != "undefined" && max !== null) {
			    	spinnerOptions['max'] = max;
			    }
			    if (typeof(step) != "undefined" && step !== null) {
			    	spinnerOptions['step'] = step;
			    }
			    $(this).spinner(spinnerOptions);
			});
	    };
		    
		function handleBoxShadow(element){

			var container = $(element).closest('.BoxShadowContainer'); 
	        var inset = container.find('.inset-shadow').is(':checked') ? 'inset ' : '';
	        var drop = container.find('.drop-shadow').is(':checked') ? 'inset ' : '';

	        if (inset == '') {
	        	container.find('.inset-shadow-color, .inset-shadow-horizontal, .inset-shadow-vertical, .inset-shadow-blur, .inset-shadow-spread').prop('disabled', true); 
	        }else{
	        	container.find('.inset-shadow-color, .inset-shadow-horizontal, .inset-shadow-vertical, .inset-shadow-blur, .inset-shadow-spread').prop('disabled', false); 
	        }
	        if (drop == '') {
	        	container.find('.drop-shadow-color, .drop-shadow-horizontal, .drop-shadow-vertical, .drop-shadow-blur, .drop-shadow-spread').prop('disabled', true); 
	        }else{
	        	container.find('.drop-shadow-color, .drop-shadow-horizontal, .drop-shadow-vertical, .drop-shadow-blur, .drop-shadow-spread').prop('disabled', false); 
	        }


	        var inset_color = container.find('.inset-shadow-color').val();
	        var inset_horizontal = container.find('.inset-shadow-horizontal').val() + 'px';
	        container.find('.inset-horizontal-value').html(inset_horizontal);
	        var inset_vertical = container.find('.inset-shadow-vertical').val() + 'px';
	        container.find('.inset-vertical-value').html(inset_vertical);
	        var inset_blur = container.find('.inset-shadow-blur').val() + 'px';
	        container.find('.inset-blur-value').html(inset_blur);
	        var inset_spread = container.find('.inset-shadow-spread').val() + 'px';
	        container.find('.inset-spread-value').html(inset_spread);

	        var drop_color = container.find('.drop-shadow-color').val();
	        var drop_horizontal = container.find('.drop-shadow-horizontal').val() + 'px';
	        container.find('.drop-horizontal-value').html(drop_horizontal);
	        var drop_vertical = container.find('.drop-shadow-vertical').val() + 'px';
	        container.find('.drop-vertical-value').html(drop_vertical);
	        var drop_blur = container.find('.drop-shadow-blur').val() + 'px';
	        container.find('.drop-blur-value').html(drop_blur);
	        var drop_spread = container.find('.drop-shadow-spread').val() + 'px';
	        container.find('.drop-spread-value').html(drop_spread);

	        if (inset != '' & drop == '') {
	        	var boxShadow = inset_horizontal + ' ' + inset_vertical + ' ' + inset_blur + ' ' + inset_spread + ' ' + inset_color + ' inset';
	        }
	        else if (drop != '' & inset == '') {
	        	var boxShadow = drop_horizontal + ' ' + drop_vertical + ' ' + drop_blur + ' ' + drop_spread + ' ' + drop_color;
	        }
	        else if (drop != '' & inset != '') {
	        	var boxShadow = drop_horizontal + ' ' + drop_vertical + ' ' + drop_blur + ' ' + drop_spread + ' ' + drop_color +' , '+inset_horizontal + ' ' + inset_vertical + ' ' + inset_blur + ' ' + inset_spread + ' ' + inset_color + ' inset';
	        }
	        else {
	        	var boxShadow = 'none';
	        }

	        
        	container.find('.ShadowBoxPreview').css('transition', 'all 0.2s ease').css('box-shadow', boxShadow);
		}

        if (jQuery('.inset-shadow,.drop-shadow').length > 0) {

			$(".inset-shadow,.drop-shadow").each(function() {
		    	handleBoxShadow(this);
			});

		    $('.inset-shadow, .inset-shadow-color, .inset-shadow-horizontal, .inset-shadow-vertical, .inset-shadow-blur, .inset-shadow-spread,.drop-shadow, .drop-shadow-color, .drop-shadow-horizontal, .drop-shadow-vertical, .drop-shadow-blur, .drop-shadow-spread').on('change input',function(){
		    	handleBoxShadow(this);
		    });
		}

		/*
		Selector Class : element-depend - w3o-depend
		*/
		jQuery('.w3o-depend').off('keyup change').on('keyup change', function() {
			w3OptionsDependField(this);
		});
		jQuery('.w3o-depend').each(function() {
			w3OptionsDependField(this);
		});
		function w3OptionsDependField(elementThis) {
			
			var el_id = jQuery(elementThis).data('depend-id');
			var el_name = el_id;
			var el_value =  jQuery(elementThis).val();
			var el_type =  jQuery(elementThis).attr('type');

			/* Fetch AjaxField */
			if (jQuery(elementThis).data('ajax_container') != undefined && jQuery(elementThis).data('ajax_url') != undefined) {
				var ajax_container = jQuery(elementThis).data('ajax_container');
				var ajax_url = jQuery(elementThis).data('ajax_url');	
				var param_name = ajax_container.replace('Container', '');
				
				jQuery.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					type: 'Post',
					url: ajax_url,
					data: {	
							'element_id' : element_id,	
							'content': el_value, 
							'param_name': param_name,
							'elementData' : serializedelementData
							},
					success : function(data)
					{
						
						if(jQuery('#'+ajax_container).length > 0)
						{
							jQuery('#'+ajax_container).html(data);	
						}
					}
				});
			}	
			/* End Fetch AjaxField */

			if (el_type == 'checkbox') {
				el_value = $('input[data-depend-id="'+el_name+'"]:checked').map(function(){
							    return $(this).val();
							}).get();
			}
			if (el_type == 'radio') {
				el_value = $('input[data-depend-id="'+el_name+'"]:checked').map(function(){
							    return $(this).val();
							}).get();
			}
			if (el_name.indexOf('[]') !== -1) {
				el_name = el_name.replace('[]', '');
			}
			var depend_el_common_class = el_name+'-depend';

			/* Hide */
			jQuery('.'+depend_el_common_class).hide();
			/* Hide end*/
			if(el_value == ""){
				return false;
			}
			
			if(jQuery('.'+depend_el_common_class).data(el_name+'-value') == undefined )
			{
				jQuery('.'+depend_el_common_class).hide();
				jQuery('.'+depend_el_common_class).removeClass("d-none").show();
			}
			else
			{
				var firstOperent = typeof(el_value) == 'string' ? '"'+el_value+'"' : el_value;	
				
				jQuery('.'+depend_el_common_class).each(function(e){
					
					secondOperator 	=	jQuery(this).data(el_name+'-operator');
					secondOperent 	=	jQuery(this).data(el_name+'-value');
					secondOperent 	= 	'"'+secondOperent+'"';
						
					if (typeof el_value === 'object' ) {

						depend_el_common_class = jQuery(this);

						$.each(el_value, function(index, value){
							firstOperent = '"'+value+'"';

							var condition = eval(firstOperent + secondOperator + secondOperent);
							
							if(condition)
							{
								jQuery(depend_el_common_class).removeClass("d-none").show();
							}
						});

					}
					else {
						var condition = eval(firstOperent + secondOperator + secondOperent);
						
						if( condition )
						{
							jQuery(this).removeClass("d-none").show();
						}
					}
				});
			}
			return true;
		}

		if (jQuery('.ThemeOptionsMainMenu').length > 0) {
			
			$('.ThemeOptionsMainMenu .nav-link').on('click', function() {
				jQuery('.nav-link').removeClass('active');
		      	var tabId = $(this).attr('href');
				
			    $('.nav-link[href="' + tabId + '"]').tab('show');
		    });

			jQuery('.ThemeOptionsMainMenu li a').on('click', function () {

				if (!jQuery(this).closest('.ThemeOptionsMainMenu > .nav-item').hasClass('active-section')) {
					jQuery('.ThemeOptionsSubMenu').slideUp();
				}
				jQuery('.nav-item').removeClass('active-section');
				jQuery(this).closest('.ThemeOptionsMainMenu > .nav-item').addClass('active-section');
				jQuery(this).closest('.nav-item.has-subsection').find('.ThemeOptionsSubMenu').slideDown();
				jQuery(this).closest('.nav-item.has-subsection').find('> a').addClass('active');
				
			});
		}

	</script>
@endpush