<?php

namespace Modules\W3Options\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Http;
use App\Models\Configuration;


$settingsFile = base_path('themes/'.config('Theme.select_theme').'/incudes/w3-options/theme-options.php');
if (file_exists($settingsFile)) {
    require_once $settingsFile;
}


class W3OptionsController extends Controller
{
    
    /**
     * Display the listing of the Theme Options in Admin.
     */
    public function theme_options()
    {   
        $themeArr = explode('/', config('Theme.select_theme'));
        $active_theme = $themeArr[1];
        $key = $active_theme.'_theme_options';
        $theme_options_data = config($key,'');
        $options_data = unserialize($theme_options_data);
        $sections = array();
        
        if (class_exists('ThemeOptions'))
        {
            $ThemeOptionsobj = new \ThemeOptions;
            $sections = $ThemeOptionsobj->sections;
        }
            
        if (!empty($sections)) {

            foreach ($sections as &$section) {

                if (!empty($section['fields'])) {

                    $unique_fields = array();

                    foreach ($section['fields'] as $field) {

                        $unique_fields[$field['id']] = $field;
                            
                    }
                    $unique_fields = array_values($unique_fields);
                    $section['fields'] = $unique_fields;
                }
            }
        }

        return view('w3options::theme-options.theme_options',compact('sections','options_data'));
    }

    /**
     * Used For Saving Theme Options in Database with theme name.
     */
    public function theme_options_save(Request $request)
    {
        $themeArr = explode('/', config('Theme.select_theme'));
        $active_theme = $themeArr[1];
        $key = $active_theme.'_theme_options';
        
        if (!empty($request->file('theme-options'))) {
            foreach($request->file('theme-options') as $imgKey => $imgValue)
            {
                if (is_array($imgValue)) {
                    foreach ($imgValue as $image) {
                        $fileName = $image->hashName();
                        $image->storeAs('public/blog-images', $image->hashName());
                        $fileFullName[] = $fileName;
                    }
                    $fileName = implode(",",$fileFullName);
                }
                else {
                    $fileName = time().'.'.$imgValue->getClientOriginalName();
                    $imgValue->storeAs('public/configuration-images', $fileName);
                }

                $request->merge([
                    'theme-options' => array_merge($request->input('theme-options'), [$imgKey => $fileName])
                ]);
            }
        }

        $optionsData = array_filter($request->input('theme-options'), function($value) {
            return ($value !== null && $value !== false && $value !== ''); 
        });

        $serializedOptionsData = serialize($optionsData);

        $configObj = New Configuration();
        $res = $configObj->saveConfig($key, $serializedOptionsData);

        return redirect()->back()->with('success', __('Theme Options Saved Successfully.'));
        
    }

    
}
