@if($currentViewName == 'single')
    @php

        $theme_options = $lemars_option;
        $blog_options = ThemeOption::GetBlogOptionById($blog->id);
        $post_banner_setting    = $blog_options['post_banner_setting'] ?? 'theme_default';

        if($post_banner_setting == 'custom')
        {   

            $show_banner     = $blog_options['post_banner_on'];
            $banner_image    = $blog_options['post_banner'];
            $banner_image    = !empty($banner_image) ? asset('storage/blog-images/'.$banner_image) : theme_asset('images/banner/pic4.jpg');

            $banner_height   = $blog_options['post_banner_height'];
            $custom_height   = $blog_options['post_banner_custom_height'];
            $show_breadcrumb = $blog_options['post_breadcrumb'];     
        }
        else
        {
            $show_banner     = config('ThemeOptions.post_general_banner_on',false);
            $banner_height   = config('ThemeOptions.post_general_banner_height','post_banner_small');
            $custom_height   = config('ThemeOptions.post_general_banner_custom_height','100');
            $banner_image    = config('ThemeOptions.post_general_banner');
            $banner_image    = !empty($banner_image) ? asset('storage/configuration-images/'.$banner_image) : theme_asset('images/banner/pic4.jpg');
            $show_breadcrumb = config('ThemeOptions.show_breadcrumb',true);       
        }

        $banner_class = '';
        $banner_custom_height = '';
        $page_heading_classes = 'dlab-bnr-inr-entry text-white';
        
        $banner_class = (empty($banner_image)) ?'bnr-no-img ':'';
        if($banner_height == 'page_banner_big') {
            $banner_class .= 'dlab-bnr-inr-md';
            $page_heading_classes = 'dlab-bnr-inr-entry text-white align-b';
        }
        else if($banner_height == 'page_banner_medium'){
            $banner_class .= 'dlab-bnr-inr-sm';
        }
        else if($banner_height == 'page_banner_custom'){
            $banner_custom_height .= $custom_height;
        }
        
        $bnr_style = "style=";
        
        if(!empty($banner_image)) {
            $bnr_style .= 'background-image:url('.$banner_image.');';
        }
        if($banner_height == 'page_banner_custom'){
            $bnr_style .= 'height:'.$banner_custom_height.'px;';
        }
    
        $subTitleClass = 'sub-title';

    @endphp
    @if ($show_banner)
        <div class="dlab-bnr-inr overlay-black-middle {{ $banner_class }} m-b30" {{ $bnr_style }}>
            <div class="container">
                <div class="{{$page_heading_classes}}">                        
                    <h1>{{ \Str::limit($blog->title, 30, '...') }}</h1>
                    
                    @if ($show_breadcrumb)
                    <!-- Breadcrumb row -->
                    <div class="breadcrumb-row">
                        <ul class="list-inline">
                            <li><a href="{{ url('/') }}"><i class="ti-home"></i> {{ __('Home') }} </a> 
                            <li>{{ \Str::limit($blog->title, 30, '...') }}</li>
                        </ul>
                    </div>
                    <!-- Breadcrumb row END -->
                    @endif

                    @if ($banner_class == 'page_banner_big')
                    <span class="line"></span>
                    @endif
                </div>
            </div>
        </div>
    @endif
@else
    @php
        $header_style = isset($lemars_option['header_style'])?$lemars_option['header_style']:'header_1';
        $theme_options = $lemars_option;
        $template_name = 'page_general';
        if ($currentViewName == 'page') {
            $page_options = ThemeOption::GetPageOptionById($page->id);
        }    
        
        $page_banner_setting    = !empty($page_options['page_banner_setting'])?$page_options['page_banner_setting']:'theme_default';
        $title_prefix           = '';

        if($currentViewName == 'author'){
            $template_name  = 'author_page';
            $title_prefix   = __('Author :');
        }
        else if($currentViewName == 'search'){
            $template_name  = 'search_page';
            $title_prefix   = __('Search :');
        }
        else if($currentViewName == 'category'){
            $template_name  = 'category_page';
            $title_prefix   = __('Category :');
        }
        else if($currentViewName == 'tag'){
            $template_name  = 'tag_page';
            $title_prefix   = __('Tag :');
        }
        else if($currentViewName == 'archive'){
            $template_name  = 'archive_page';
            $title_prefix   = __('Archive :');
        }

        $page_banner_title = $page_banner_sub_title = '';
        
        if($page_banner_setting == 'custom')
        {

            $show_banner        = $page_options['page_banner_on'] ?? null;
            $page_banner_hide   = $page_options['page_banner_hide'] ?? null;
            $banner_type        = $page_options['page_banner_type'] ?? null;
            $banner_height      = $page_options['page_banner_height'] ?? null;
            $custom_height      = $page_options['page_banner_custom_height'] ?? null;
            $banner_image       = $page_options['page_banner'] ?? null;
            $banner_image       = !empty($banner_image) ? asset('storage/page-images/'.$banner_image) : theme_asset('images/banner/pic4.jpg');

            $banner_hide            = $page_options['page_banner_hide'] ?? null;
            $page_banner_title      = $page_options['page_banner_title'] ?? null;
            $page_banner_sub_title  = $page_options['page_banner_sub_title'] ?? null;       
            $show_breadcrumb    = $page_options['page_breadcrumb'] ?? null;
        }
        else
        {
            $title_prefix       = config('ThemeOptions.'.$template_name.'_title',$title_prefix);
            $show_banner        = config('ThemeOptions.'.$template_name.'_banner_on',true);
            $page_banner_hide   = config('ThemeOptions.'.$template_name.'_page_banner_hide',true);
            $banner_type        = config('ThemeOptions.'.$template_name.'_banner_type','image');
            $banner_height      = config('ThemeOptions.'.$template_name.'_banner_height','page_banner_small');
            $custom_height      = config('ThemeOptions.'.$template_name.'_banner_custom_height','100');  
            $banner_image       = config('ThemeOptions.'.$template_name.'_banner');
            $banner_image       = !empty($banner_image) ? asset('storage/configuration-images/'.$banner_image) : theme_asset('images/banner/pic4.jpg');
            $show_breadcrumb    = config('ThemeOptions.show_breadcrumb',true);
            $banner_hide        = config('ThemeOptions.'.$template_name.'_banner_hide');
        }

        $page_heading_classes = 'dlab-bnr-inr-entry text-white';
        
        $banner_class = (empty($banner_image)) ?'bnr-no-img ':'';

        if($banner_height == 'page_banner_big') {
            $banner_class .= 'dlab-bnr-inr-md';
            $page_heading_classes = 'dlab-bnr-inr-entry text-white align-b';
        }
        else if($banner_height == 'page_banner_medium'){
            $banner_class .= 'dlab-bnr-inr-sm';
        }
        else if($banner_height == 'page_banner_custom'){
            $banner_class .= $custom_height;
        }
        

        $bnr_style = "style=";
        
        if(!empty($banner_image)) {
            $bnr_style .= 'background-image:url('.$banner_image.');';
        }
        if($banner_height == 'page_banner_custom'){
            $bnr_style .= 'height:'.$custom_height.'px;';
        }

    @endphp

    @if ($show_banner != 0)
    
        <div class="dlab-bnr-inr overlay-black-middle {{ $banner_class }} m-b30" {{$bnr_style}}>
            <div class="container">
                <div class="{{$page_heading_classes}}">                        
                    
                    @if ($header_style == 'header_3' && !empty($page_banner_sub_title))
                    <p>{{ $page_banner_sub_title }}</p>
                    @endif
                    <h1>
                       {{ !empty($page_banner_title) ? $page_banner_title : $title_prefix.' '.$pageTitle }}
                    </h1>
                    
                    @if ($show_breadcrumb)
                    <!-- Breadcrumb row -->
                    <div class="breadcrumb-row">
                        <ul class="list-inline">
                            <li><a href="{{ url('/') }}"><i class="ti-home"></i> Home </a> 
                            <li>{{ !empty($page_banner_title) ? $page_banner_title : $title_prefix.' '.$pageTitle }}</li>
                        </ul>
                    </div>
                    <!-- Breadcrumb row END -->
                    @endif

                    @if ($banner_height == 'page_banner_big')
                    <span class="line"></span>
                    @endif

                </div>
            </div>
        </div>
    @endif
@endif