<?php

require_once 'functions.php';

if (!class_exists('ThemeOptions'))
{
    class ThemeOptions
    {
        public $args = array();
        public $sections = array();
        public $theme;
        public $ReduxFramework;
        public $page_template_options;
        public $coming_template_options;
        public $maintenance_template_options;
        public $error_template_options;
        public $header_style_options;
        public $footer_style_options;
        public $post_layouts_options;
        public $sidebar_layout_options;
        public $page_banner_options;
        public $post_banner_options;
        public $theme_layout_options;
        public $theme_color_background_options;
        public $theme_image_background_options;
        public $theme_pattern_background_options;
        public $theme_color_options;
        public $page_loader_options;
        public $sort_by_options;
        public $link_target_options;
        public $social_link_options;
        public $banner_type;

        function __construct() 
        {
            

            /** Option Variable assigning values **/
            $this->page_template_options = get_page_template_options();
            $this->coming_template_options = get_coming_template_options();
            $this->maintenance_template_options = get_maintenance_template_options();
            $this->error_template_options = get_error_template_options();
            $this->header_style_options = get_header_style_options();
            $this->footer_style_options = get_footer_style_options();
            $this->post_layouts_options = get_post_layouts_options();
            $this->sidebar_layout_options = get_sidebar_layout_options();
            $this->page_banner_options = get_page_banner_options();
            $this->post_banner_options = get_post_banner_options();
            $this->theme_layout_options = get_theme_layout_options();
            $this->theme_color_background_options = get_theme_color_background_options();
            $this->theme_image_background_options = get_theme_image_background_options();
            $this->theme_pattern_background_options = get_theme_pattern_background_options();
            $this->theme_color_options = get_theme_color_options();
            $this->page_loader_options = get_page_loader_options();
            $this->sort_by_options = get_sort_by_options();
            $this->link_target_options = get_link_target_options();
            $this->social_link_options = get_social_link_options();
            $this->social_share_options = get_social_share_options();
            $this->banner_type = banner_type();
            $this->fontawesome_icon = get_fontawesome_icon();
            /** End Option Variable assigning values **/

            /* Just for demo purposes. Not needed per say. */
            $themeArr = explode('/', config('Theme.select_theme'));
            $this->theme = $themeArr[1];

            // dd(config('ThemeOptions.website_status'));

            /* Create the sections and fields */
            $this->setSections();

        }

        /**
         * All the possible sections for Redux.
         *
         */
        function setSections() {
            
            /*--------------------------------------------------------------
            # 1. General Settings
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title'  => __('General Settings'),
                'desc'   => __('General Settings is a global setting that will affects all the pages of you website. From here you can make changes globaly. The setting will apply if there is no individual settings.'),
                'icon'   => 'fas fa-home',
                'fields' => array(
                    array(
                        'id'       => 'website_status',
                        'type'     => 'button_set',
                        'title'    => __('Website Status'),
                        'subtitle' => __('Click on the option tabs to change the status of your website.'),
                        'desc'     => __('Select option tabs to change the status.'),
                        'options'  => array(
                            'live_mode'  => __('Live'),
                            'comingsoon_mode'  => __('Coming Soon'),
                            'maintenance_mode'  => __('Site Down For Maintenance')
                        ),
                        'default'  => 'live_mode',
                        'hint'     => array(
                            'title'   => __('Status'),
                            'content' => __('1. Live status indicate that your website is available and operational.') . '<br><br>' . __('2. Coming Soon status show your website visitors that you are working on your website for making it better.') . '<br><br>' . __('3. Maintenance mode show your website visitors that you are working on your website for making it better.') . '<br><br> <strong>Note : </strong> ' . __(' Coming soon template and maintenance template will not show when user login.')
                        )
                    ),
                    
                    array(
                        'id'       => 'coming_soon_template',
                        'type'     => 'image_select',
                        'title'    => __('Coming Soon Template'),
                        'subtitle' => __('Choose the template for Coming Soon page. (Default : 1).'),
                        'desc'     => __('Click on the icon to change the template.'),
                        'options'  => $this->coming_template_options,
                        'default'  => 'coming_style_1',
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'comingsoon_mode')
                        ),
                        'hint'     => array(
                            'title'   => __('Hint Title'),
                            'content' => __('Choose the coming soon template design as you want to show.')
                        )
                    ),
                    array(
                        'id'       => 'comingsoon_bg',
                        'type'     => 'media',
                        'url'      => true,
                        'title'    => __('Coming Soon Page Background'),
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'comingsoon_mode')
                        ),
                        
                    ),
                    array(
                        'id'       => 'comingsoon_launch_date',
                        'type'     => 'date',
                        'title'    => __('Coming soon Date'),
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'comingsoon_mode')
                        ),
                    ),
                    array(
                        'id'       => 'maintenance_template',
                        'type'     => 'image_select',
                        'title'    => __('Maintenance Template'),
                        'subtitle' => __('Choose the template for Maintenance page. (Default : 1).'),
                        'desc'     => __('Click on the icon to change the template.'),
                        'options'  => $this->maintenance_template_options,
                        'default'  => 'maintenance_style_1',
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'maintenance_mode')
                        ),
                        'hint'     => array(
                            'title'   => __('Hint Title'),
                            'content' => __('Choose the maintenance template design as you want to show.')
                        )
                    ),
                    
                    array(
                        'id'       => 'maintenance_bg',
                        'type'     => 'media',
                        'url'      => true,
                        'title'    => __('Maintenance Page Background'),
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'maintenance_mode')
                        ),
                    ),
                    array(
                        'id'       => 'maintenance_icon',
                        'type'     => 'media',
                        'url'      => true,
                        'title'    => __('Maintenance Page Icon'),
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'maintenance_mode')
                        ),
                    ),
                    array(
                        'id'       => 'maintenance_title',
                        'type'     => 'textarea',
                        'title'    => __('Maintenance Page Title'),
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'maintenance_mode')
                        ),
                        'default'  => __('Site Is Down').' <br/>'.__('For Maintenance'),
                    ),
                    array(
                        'id'       => 'maintenance_desc',
                        'type'     => 'textarea',
                        'title'    => __('Maintenance Page Description'),
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'maintenance_mode')
                        ),
                        'default'  => __('This is the Technical Problems Page.').' <br/>'.__('Or any other page.'),
                    ),
                    array(
                        'id'       => 'logo_type',
                        'type'     => 'button_set',
                        'title'    => __('Logo Type'),
                        'subtitle' => __('Choose the logo type'),
                        'desc'     => __('Click on the tab to change the logo type.'),
                        'options'  => array(
                            'image_logo'  => __('Image Logo'),
                            'text_logo'  => __('Text Logo')
                        ),
                        'default'  => 'image_logo',
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'live_mode')
                        ),
                        'hint'     => array(
                            'title'   => __('Choose Logo Type:'),
                            'content' => __('1. Image Logo will be the .pmg / .jpg type. This setting affects all the site pages.') .'<br><br>'. __('2. Text Logo will the text type. This setting affects all the site pages.')
                        )
                    ),
                    array(
                        'id'       => 'blog_page_title',
                        'type'     => 'text',
                        'title'    => __('Blog Page Title'),
                        'desc'     => __('Default blog page title.'),
                        'default'  => __('Blog'),
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'live_mode')
                        ),
                    ),
                    
                    array(
                        'id'       => 'show_social_icon',
                        'type'     => 'switch',
                        'title'    => __('Social Icon'),
                        'subtitle' => __('Click on the tab to Enable / Disable the social icon setting.'),
                        'desc'     => __('Once you click on disable, This setting affects all the site pages.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false,
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'live_mode')
                        ),
                    ),
                    array(
                        'id'       => 'show_breadcrumb',
                        'type'     => 'switch',
                        'title'    => __('Breadcrumb Area'),
                        'subtitle' => __('Click on the tab to Enable / Disable the website breadcrumb.'),
                        'desc'     => __('Once you click on disable, This setting affects all the site pages.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true,
                        'hint' => array(
                            'title' => __('Select Breadcrumb Area:') ,
                            'content' => __('This breadcrumb option only works when page level banner Theme Settings option selected. This option will not work when custom settings selected.'),
                        ),
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'live_mode')
                        ),
                    ),
                    array(
                        'id'       => 'show_login_registration',
                        'type'     => 'switch',
                        'title'    => __('Login / Register'),
                        'subtitle' => __('Click on the tab to Enable / Disable the login / register button / likns.'),
                        'desc'     => __('Once you click on disable, This setting affects all the site pages.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false,
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'live_mode')
                        ),
                        'hint'     => array(
                            'title'   => __('Login/Register Visible'),
                            'content' => __('This is show in top bar.')
                        )
                    ),
                    array(
                        'id'       => 'show_sidebar',
                        'type'     => 'switch',
                        'title'    => __('Sidebar'),
                        'subtitle' => __('Click on the tab to Enable / Disable the sidebar.'),
                        'desc'     => __('Once you click on disable, This setting affects all the site pages.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true,
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'live_mode')
                        ),
                    ),
                    array(
                        'id' => 'site_phone_number',
                        'type' => 'text',
                        'title' => __('Phone Number') ,
                        'subtitle' => __('Show in header top ') ,
                        'default' => '+91-1234567890',
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'live_mode')
                        ),
                    ) ,
                    array(
                        'id' => 'site_email',
                        'type' => 'text',
                        'title' => __('Email') ,
                        'subtitle' => __('Show in header top ') ,
                        'default' => 'info@example.com',
                        'depend_on' => array(
                            'website_status' => array('operator' => '==',"value" => 'live_mode')
                        ),
                    ),
                )
            );
            

            /*--------------------------------------------------------------
            # 2. Logo Settings
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title'  => __('Logo Settings'),
                'icon'   => 'fas fa-cogs',
                'fields' => array(
                    array(
                        'id'       => 'favicon',
                        'type'     => 'media',
                        'url'      => true,
                        'title'    => __('Favicon'),
                        'subtitle' => __('Select favicon image.'),
                        'desc' => __('Upload favicon image.'),
                        'hint'     => array(
                            'title'   => __('Favicon'),
                            'content' => __('From here you can upload an image. This setting affects all the site pages.')
                        )
                    ),
                    array(
                        'id'       => 'logo_text',
                        'type'     => 'text',
                        'title'    => __('Logo Text'),
                        'subtitle' => __('Name your text logo.'),
                        'default'  => config('Site.title'),
                    ),
                    array(
                        'id'       => 'tag_line',
                        'type'     => 'text',
                        'title'    => __('Tag Line'),
                        'subtitle' => __('Name a tagline for the text logo.'),
                        'default'  => config('Site.tagline'),
                    ),
                    array(
                        'id'       => 'logo_title',
                        'type'     => 'text',
                        'title'    => __('Logo Title'),
                        'subtitle' => __('Title attribute for the logo. This attribute specifies extra information about the logo. Most browsers will show a tooltip with this text on logo hover.'),
                        'default'  => config('Site.title'),

                    ),
                    array(
                        'id'       => 'logo_alt',
                        'type'     => 'text',
                        'title'    => __('Logo Alt'),
                        'subtitle' => __('Alt attribute for the logo. This is the alternative text if the logo cannot be displayed. It`s useful for SEO and generally is the name of the site.'),
                        'default'  => config('Site.title'),
                    ),
                    array(
                       'id' => 'logo-section-start',
                       'type' => 'section',
                       'title' => __('Site Logo Setting'),
                       'indent' => true
                    ),
                    array(
                        'id'       => 'site_logo',
                        'type'     => 'media',
                        'url'      => true,
                        'title'    => __('Logo'),
                        'subtitle' => __('Upload your logo (272 x 90px) .png or .jpg'),
                    ),
                    array(
                        'id'       => 'site_other_logo',
                        'type'     => 'media',
                        'url'      => true,
                        'title'    => __('Other Logo'),
                        'subtitle' => __('Upload your logo (272 x 90px) .png or .jpg'),
                    ),
                    array(
                        'id'     => 'logo-section-end',
                        'type'   => 'section',
                        'indent' => false,
                    ),
                )
            );


            /*--------------------------------------------------------------
            # 3. Header Settings
            --------------------------------------------------------------*/
            $header_social_links = $header_social_defaults = array();

            foreach ($this->social_link_options as $social_link) {

                $link_value = config('ThemeOptions.social_' . $social_link['id'] . '_url');
                
                if( !empty( $link_value ) ) {
                    $header_social_links[$social_link['id']] = $social_link['title'];
                    $header_social_defaults[$social_link['id']] = false;
                }
            }

            $header_style_options = header_style_options();
            $header_aditional_array= array();
            $mobile_header_aditional_array = array();
            foreach($header_style_options as $header)
            {
                $header_id = $header['id']; 
                
                $header_social_defaults_1 = $header_social_defaults;

                $header_search_on   = $header['param']['search'] ?? false;
                $social_link        = $header['param']['social_link'] ?? false;
                $header_top_bar     = $header['param']['top_bar'] ?? false;    
                $call_to_action_button = $header['param']['call_to_action_button'] ?? 0;
                
                $total_links = $header['param']['social_links'] ?? 0;  
                if($total_links > 0 )
                {
                    $i = 1;
                    foreach($header_social_links as $key => $value)
                    {
                        if($i <= $total_links)
                        {
                            $header_social_defaults_1[$key] = 1;
                        }
                        else
                        {
                            $header_social_defaults_1[$key] = 0;    
                        }
                        $i++;
                    }   
                }   

                /******Header Related Fields *****/
                
                 $header_aditional_array[] = array(
                    'id'       => $header_id.'_top_bar_on',
                    'type'     => 'switch',
                    'title'    => __('Top Bar'),
                    'subtitle' => __('Show or hide the top bar.'),
                    'on'       => __('Enabled'),
                    'off'       => __('Disabled'),
                    'default'  => $header_top_bar,
                    'depend_on' => array(
                        'header_style' => array('operator' => '==',"value" => $header_id)
                    ),
                ); 
                
                
                $header_aditional_array[] = array(
                    'id'       => $header_id.'_social_link_on',
                    'type'     => 'switch',
                    'title'    => __('Social Link'),
                    'subtitle' => __('Show or hide the hader social link option.'),
                    'on'       => __('Enabled'),
                    'off'       => __('Disabled'),
                    'default'  => $social_link,
                    'depend_on' => array(
                        'header_style' => array('operator' => '==',"value" => $header_id)
                    ),
                );
                
                $header_aditional_array[] = array(
                    'id'       => $header_id.'_social_links',
                    'type'     => 'checkbox_multi',
                    'title'    => __('Choose for this Header' ),
                    'subtitle' => __('No validation can be done on this field type' ),
                    'desc'     => __('This is the description field, again good for additional info.' ),
                    //Must provide key => value pairs for multi checkbox options
                    'options'  => $header_social_links,
                    //See how std has changed? you also don't need to specify opts that are 0.
                    'default'  => $header_social_defaults_1,
                    'depend_on' => array( //required
                        'header_style' => array('operator' => '==',"value" => $header_id),
                        $header_id.'_social_link_on' => array('operator' => '==',"value" => 1)
                    ),
                );
                
                if($call_to_action_button > 0 )
                {                   
                    for($i = 1; $i <= $call_to_action_button; $i++ )
                    {
                        $header_aditional_array[] = array(
                            'id'       => $header_id.'_button_'.$i.'_text',
                            'type'     => 'text',
                            'title'    => __('Button ').$i. __(' Text'),
                            'default'  => '',
                            'depend_on' => array(
                                'header_style' => array('operator' => '==',"value" => $header_id)
                            ),
                        );
                        $header_aditional_array[] = array(
                            'id'       => $header_id.'_button_'.$i.'_url',
                            'type'     => 'text',
                            'title'    => __('Button ').$i.__(' URL'),
                            'default'  => '',
                            'depend_on' => array(
                                'header_style' => array('operator' => '==',"value" => $header_id)
                            ),  
                        );
                        $header_aditional_array[] = array(
                            'id'       => $header_id.'_button_'.$i.'_target',
                            'type'     => 'select',
                            'title'    => __('Choose Button ').$i.__(' Target'),
                            'options'  => $this->link_target_options,
                            'default'  => '_self',
                            'depend_on' => array(
                                'header_style' => array('operator' => '==',"value" => $header_id)
                            ),
                        );  
                    }   
                }

                $mobile_header_aditional_array[] = array(
                    'id'       => $header_id.'_mobile_social_link_on',
                    'type'     => 'switch',
                    'title'    => __('Header Social Link'),
                    'subtitle' => __('Show or hide the hader social link option.'),
                    'on'       => __('Enabled'),
                    'off'       => __('Disabled'),
                    'default'  => $social_link,
                    'depend_on' => array(
                        'header_style' => array('operator' => '==',"value" => $header_id)
                    ),
                );
               
            }

            

            $headerDefaultOption = array(
                'title'  => __('Header Settings'),           
                'icon'   => 'fas fa-heading',
                'fields' => array(
                    array(
                        'id'       => 'header_style',
                        'type'     => 'image_select',
                        'title'    => __('Header Style'),
                        'subtitle' => __('Choose header style. White header is set as default header for all theme.'),
                        'options'  => $this->header_style_options,
                        'default'  => 'header_1',
                        'hint'    => array(
                            array(
                                'title'   => 'Hint Title',
                                'content' => 'This is the content of the tool-tip'
                            )
                        )
                    ),
                    array(
                        'id'       => 'header_subscribe_on',
                        'type'     => 'switch',
                        'title'    => __('Contact Button'),
                        'subtitle' => __('Show or hide the Contact button.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false,
                    ),
                    array(
                        'id'       => 'header_login_on',
                        'type'     => 'switch',
                        'title'    => __('Login'),
                        'subtitle' => __('Show or hide the header login option.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false
                    ),
                    array(
                        'id'       => 'header_register_on',
                        'type'     => 'switch',
                        'title'    => __('Register'),
                        'subtitle' => __('Show or hide the header register option.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false,
                    ),
                    array(
                        'id'       => 'header_sticky_on',
                        'type'     => 'switch',
                        'title'    => __('Sticky Header'),
                        'subtitle' => __('Header will be sticked when applicable.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false
                    ),
                    array(
                       'id' => 'mobile_section_start',
                       'type' => 'section',
                       'title' => __('Mobile Device Options'),
                       'indent' => false
                    ),
                    array(
                        'id'       => 'mobile_header_login_on',
                        'type'     => 'switch',
                        'title'    => __('Login'),
                        'subtitle' => __('Show or hide the header login option.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false
                    ),
                    array(
                        'id'       => 'mobile_header_register_on',
                        'type'     => 'switch',
                        'title'    => __('Register'),
                        'subtitle' => __('Show or hide the header register option.'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false
                    ),
                )
            );

            array_splice( $headerDefaultOption['fields'], 4, 0, $header_aditional_array );
            $mobileFieldPosition = count($headerDefaultOption['fields']);
            array_splice( $headerDefaultOption['fields'], $mobileFieldPosition , 0, $mobile_header_aditional_array );
            
            $this->sections[] = $headerDefaultOption;



            /*--------------------------------------------------------------
            # 4. Footer
            --------------------------------------------------------------*/
            
            
            $footer_setting_fields[] = array(
                'id'      => 'footer_on',
                'type'    => 'switch',
                'title'   => __('Footer'),
                'on'      => __('Enabled'),
                'off'     => __('Disabled'),
                'default' => true
            );
            $footer_setting_fields[] = array(
                'id'       => 'footer_style',
                'type'     => 'image_select',
                'title'    => __('Footer Template'),
                'subtitle' => __('Choose a template for footer.'),
                'options'  => $this->footer_style_options,
                'default'  => 'footer_template_1',
                'depend_on' => array(
                    'footer_on' => array('operator' => '==',"value" => '1')
                ),
            );
            
            $footer_setting_fields[] = array(
                'id'      => 'footer_subscription_section',
                'type'    => 'switch',
                'title'   => __('Subscription Section'),
                'subtitle' => __('Mailchimp subscription'),
                'on'      => __('Enabled'),
                'off'     => __('Disabled'),
                'default' => false
            );
            $footer_setting_fields[] = array(
                'id'       => 'subscription_section_image',
                'type'     => 'media',
                'url'      => true,
                'title'    => __('Subscription Image'),
                'subtitle' => __('Show or hide the image.'),
                'depend_on' => array(
                    'footer_subscription_section' => array('operator' => '==',"value" => 1)
                ),
            );
            
            $footer_setting_fields[] = array(
                'id'       => 'subscription_section_title',
                'type'     => 'text',
                'title'    => __('Subscription Section Title'),
                'subtitle' => __('Write subscription title.'),
                'default'  => __('Subscribe to My Blog'),
                'depend_on' => array(
                    'footer_subscription_section' => array('operator' => '==',"value" => 1)
                ),
            );

            $footer_setting_fields[] = array(
                'id'       => 'subscription_section_bg_text',
                'type'     => 'text',
                'title'    => __('Subscription Section Background Title'),
                'default'  => __('subscribe'),
                'depend_on' => array(
                    'footer_subscription_section' => array('operator' => '==',"value" => 1)
                ),
            );  
            
            
            $footer_style_options = footer_style_options();
            $total_footer = count($this->footer_style_options);

            foreach($footer_style_options as $key => $value)
            {
                $footer_id =  $value['id'];
                
                if($value['param']['copyright'] == 1)
                {
                        
                }

                if($value['param']['powered_by'] == 1)
                {
                        
                }

            }           
            
            $footer_setting_fields[] = array(
                'id'       => 'footer_copyright_text',
                'type'     => 'text',
                'title'    => __('Copyright Text'),
                'subtitle' => __('Write footer copyright text here.'),
                'default'  => __('© 2024 All Rights Reserved.'),
                'depend_on' => array(
                    'footer_on' => array('operator' => '==',"value" => '1')
                ),
            );
            
            $this->sections[] = array(
                'title'  => __('Footer Settings'),
                'desc'   => __('The footer uses widgets to show information. Here you can customize the number of layouts. In order to add widgets to the footer go to footer widgets section and drag widget to the footer block.'),
                'icon'   => 'fa fa-home',
                'fields' => $footer_setting_fields
            );

            /*--------------------------------------------------------------
            # 5. Post Setting
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title'  => __('Post Settings'),
                'icon'   => 'fas fa-newspaper'
            );
            
            $this->sections[] = array(
                'title'  => __('General Settings'),
                'desc' => __('This option will work on all new post and edit post sections. On new post page we will display only Post Layout Selection , all other settings will be applicable from here.'),
                'subsection' => true,
                'icon'   => 'fas fa-cog',
                'fields' => array(
                    array(
                        'id'       => 'post_general_layout',
                        'type'     => 'image_select',
                        'height'   => '100',
                        'title'    => __('Single Post Layout'),
                        'subtitle' => __('Select a layout for post page.'),
                        'desc'     => __('Click on the template icon to select.'),
                        'options'  => $this->post_layouts_options,
                        'default'  => 'standard',
                        'hint'     => array(
                            'title'   => __('How it Works?'),
                            'content' => __('Once you select the template from here the template will apply for default post page.')
                        )
                    ),
                    array(
                        'id'       => 'date_on',
                        'type'     => 'switch',
                        'title'    => __('Date'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true
                    ),
                    array(
                        'id'       => 'comment_count_on',
                        'type'     => 'switch',
                        'title'    => __('Comment Count'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true
                    ),
                    array(
                        'id'       => 'comment_view_on',
                        'type'     => 'switch',
                        'title'    => __('Comment View'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true
                    ),
                    array(
                        'id'       => 'author_box_on',
                        'type'     => 'switch',
                        'title'    => __('Author Box'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false
                    ),
                    array(
                        'id'       => 'category_on',
                        'type'     => 'switch',
                        'title'    => __('Category'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true
                    ),
                    
                    array(
                        'id'       => 'pre_next_post_on',
                        'type'     => 'switch',
                        'title'    => __('Previous & Next Post'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true
                    ),
                    array(
                        'id'       => 'featured_img_on',
                        'type'     => 'switch',
                        'title'    => __('Featured Image'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true
                    ),
                     array(
                        'id'        => 'post_general_banner_on',
                        'type'      => 'switch',
                        'title'     => __('Post Banner') ,
                        'on'        => __('Enabled') ,
                        'off'       => __('Disabled') ,
                        'default'   => false
                    ) , 
                     array(
                        'id'        => 'post_general_banner_height',
                        'type'      => 'image_select',
                        'title'     => __('Post Banner Height') ,
                        'subtitle'  => __('Choose the height for all tag page banner. Default : Small Banner') ,
                        'height'    => '40',
                        'options'   => $this->page_banner_options,
                        'default'   => 'page_banner_small',
                        'depend_on' => array(
                            'post_general_banner_on' => array('operator' => '==',"value" => 1)
                        ),
                    ) ,
                    array(
                        'id'            =>  'post_general_banner_custom_height',
                        'type'          => 'slider',
                        'title'         => __('Page Banner Custom Height') ,
                        'desc'          => __('Hight description. Min: 100, max: 800') ,
                        'default'       => '',
                        'min'           => 100,
                        'max'           => 800,
                        'display_value' => 'text',
                        'depend_on' => array(
                            'post_general_banner_height' => array('operator' => '==',"value" => 'page_banner_custom')
                        ),
                    ) ,
                    array(
                        'id'        => 'post_general_banner',
                        'type'      => 'media',
                        'url'       => true,
                        'title'     => __('Post Banner Image') ,
                        'subtitle'  => __('Enter page banner image. It will work as default banner image for all pages') ,
                        'desc'      => __('Upload banner image.') ,
                        'default'   => '',
                        'depend_on' => array(
                            'post_general_banner_on' => array('operator' => '==',"value" => 1)
                        ),
                    ) ,
                    
                )
            );

            

                    
            /*--------------------------------------------------------------
            # 6. Page Setting
            --------------------------------------------------------------*/

            $this->sections[] = array(
                'title'  => __('Page Settings'),
                'icon'   => 'fas fa-file'
            );

            $this->sections[] = array(
                'title'  => __('General Settings'),
                'icon'   => 'fas fa-cog',
                'desc'   => '',
                'subsection' => true,
                'fields' => array(
                    array(
                        'id'       => 'page_general_banner_on',
                        'type'     => 'switch',
                        'title'    => __('Page Banner'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => true
                    ),
                    array(
                        'id'       => 'page_general_banner_type',
                        'type'     => 'button_set',
                        'title'    => __('Page Banner Type'),
                        'options'  => $this->banner_type,
                        'default'  => 'image',
                        'depend_on' => array(
                            'page_general_banner_on' => array('operator' => '==',"value" => '1')
                        ),
                    ),
                    array(
                       'id' => 'general-img-banner-section-start',
                       'type' => 'section',
                       'title' => __('Image Banner Setting'),
                       'indent' => true,
                       'depend_on' => array(
                            'page_general_banner_type' => array('operator' => '==',"value" => 'image')
                        ),
                    ),
                    array(
                        'id'       => 'page_general_banner_height',
                        'type'     => 'image_select',
                        'title'    => __('Page Banner Height'),
                        'subtitle' => __('Choose the height for all tag page banner. Default : Big Banner'),
                        'height'   => '40',
                        'options'  => $this->page_banner_options,
                        'default'  => 'page_banner_small',
                        'depend_on' => array(
                            'page_general_banner_type' => array('operator' => '==',"value" => 'image')
                        ),
                    ),
                    array(
                        'id' => 'page_general_banner_custom_height',
                        'type' => 'slider',
                        'title' => __('Page Banner Custom Height'),
                        'desc' => __('Hight description. Min: 100, max: 800'),
                        "default" => '',
                        "min" => 100,
                        "max" => 800,
                        'display_value' => 'text',
                        'depend_on' => array(
                            'page_general_banner_height' => array('operator' => '==',"value" => 'page_banner_custom')
                        ),
                    ),
                   array(
                        'id'       => 'page_general_banner',
                        'type'     => 'media',
                        'url'      => true,
                        'title'    => __('Page Banner Image'),
                        'subtitle' => __('Enter page banner image. It will work as default banner image for all pages'),
                        'desc' => __('Upload banner image.'),
                        'default'  => '',
                        'depend_on' => array(
                            'page_general_banner_type' => array('operator' => '==',"value" => 'image')
                        ),
                    ),
                    array(
                        'id'     => 'general-img-banner-section-end',
                        'type'   => 'section',
                        'indent' => false,
                    ),
                    array(
                       'id' => 'general-sidebar-section-start',
                       'type' => 'section',
                       'title' => __('Sidebar Setting'),
                       'indent' => true
                    ),
                    array(
                        'id'       => 'page_general_show_sidebar',
                        'type'     => 'switch',
                        'title'    => __('Sidebar'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => config('ThemeOptions.show_sidebar')
                    ),
                    array(
                        'id'       => 'page_general_sidebar_layout',
                        'type'     => 'image_select',
                        'title'    => __('Sidebar Layout'),
                        'subtitle' => __('Choose the layout for page. (Default : Right Side).'),
                        'options'  => $this->sidebar_layout_options,
                        'default'  => 'right',
                        'depend_on' => array(
                            'page_general_show_sidebar' => array('operator' => '==',"value" => '1')
                        ),
                    ),
                    array(
                        'id'     => 'general-sidebar-section-end',
                        'type'   => 'section',
                        'indent' => false,
                    ),
                    array(
                        'id'       => 'page_general_paging',
                        'type'     => 'button_set',
                        'title'    => __('Pagination '),
                        'options'  => array(
                            'default'  => __('Default'),
                            'load_more'  => __('Load More'),
                           
                        ),
                        'default'  => 'default',
                        'force_output' => true
                    ),
                   
                    
                )
            );
            
            $default_pages_data = array(                
                'page_author' => array(
                    'top_desc' => 'The author template is shown when a user clicks on the author in the front end of the site.',
                    'id' => 'author',
                    'title' => 'Author',
                    'icon' => 'fas fa-user'
                ),
                'page_category' => array(
                    'top_desc' => 'When a user requests a page or post that doesn`t exists, WordPress will use this template.',
                    'id' => 'category',
                    'title' => 'Category',
                    'icon' => 'fas fa-list-alt'
                ),
                'page_search' => array(
                    'top_desc' => 'Set the default layout for all the categories.',
                    'id' => 'search',
                    'title' => 'Search',
                    'icon' => 'fas fa-search'
                ),
                'page_archive' => array(
                    'top_desc' => 'This template is used by WordPress to generate the archives. By default WordPress generates daily, monthly and yearly archives.',
                    'id' => 'archive',
                    'title' => 'Archive',
                    'icon' => 'fas fa-archive'
                ),
                'page_tag' => array(
                    'top_desc' => 'Set the default layout for all the categories.',
                    'id' => 'tag',
                    'title' => 'Tag',
                    'icon' => 'fas fa-tags'
                ),
               
                
            );

            foreach ($default_pages_data as $key => $page_data) {
                
                $pg_desc = $page_data['top_desc'];
                $pg_id   = $page_data['id'];
                $pg_name = $page_data['title'];
                $pg_icon = $page_data['icon'];
                $pg_sidebar = !empty($page_data['sidebar'])?$page_data['sidebar']:'dz_default_sidebar';

                if ($key == 'page_cmsoon') {
                    $page_templates = $this->coming_template_options;
                }
                elseif ($key == 'page_maintenance') {
                    $page_templates = $this->maintenance_template_options;
                }
                else {
                    $page_templates = $this->page_template_options;
                }
                
                $page_default_settings = $page_sorting = $page_pagination = array();
                
                $page_default_settings = array(
                                                array(
                                                    'id'       => $pg_id . '_page_title',
                                                    'type'     => 'text',
                                                    'title'    => __('Page Title'),
                                                    'default'  => $pg_name . __(' : '),
                                                    'force_output' => true
                                                ),
                                                array(
                                                    'id'       => $pg_id . '_page_banner_on',
                                                    'type'     => 'switch',
                                                    'title'    => __('Page Banner'),
                                                    'on'       => __('Enabled'),
                                                    'off'       => __('Disabled'),
                                                    'default'  => false
                                                ),
                                                
                                                array(
                                                    'id'       => $pg_id . '_page_banner_type',
                                                    'type'     => 'button_set',
                                                    'title'    => __('Page Banner Type'),
                                                    'options'  => $this->banner_type,
                                                    'default'  => 'image',
                                                    'depend_on' => array(
                                                        $pg_id . '_page_banner_on' => array('operator' => '==',"value" => '1')
                                                    ),
                                                ),
                                                array(
                                                   'id' => $pg_id . '-img-banner-section-start',
                                                   'type' => 'section',
                                                   'title' => __('Image Banner Setting'),
                                                   'indent' => true,
                                                   'depend_on' => array(
                                                        $pg_id . '_page_banner_type' => array('operator' => '==',"value" => 'image')
                                                    ),
                                                ),
                                                array(
                                                    'id'       => $pg_id . '_page_banner_height',
                                                    'type'     => 'image_select',
                                                    'title'    => __('Page Banner Height'),
                                                    'subtitle' => __('Choose the height for page banner. Default : Big Banner'),
                                                    'height'   => '40',
                                                    'options'  => $this->page_banner_options,
                                                    'default'  => 'page_banner_small',
                                                    'depend_on' => array(
                                                        $pg_id . '_page_banner_type' => array('operator' => '==',"value" => 'image')
                                                    ),
                                                ),
                                                array(
                                                    'id' => $pg_id . '_page_banner_custom_height',
                                                    'type' => 'slider',
                                                    'title' => __('Page Banner Custom Height'),
                                                    'desc' => __('Hight description. Min: 100, max: 800'),
                                                    "default" => '',
                                                    "min" => 100,
                                                    "max" => 800,
                                                    'display_value' => 'text',
                                                    'depend_on' => array(
                                                        $pg_id . '_page_banner_height' => array('operator' => '==',"value" => 'page_banner_custom')
                                                    ),
                                                ),
                                                array(
                                                    'id'       => $pg_id . '_page_banner',
                                                    'type'     => 'media',
                                                    'url'      => true,
                                                    'title'    => __('Page Banner Image'),
                                                    'subtitle' => __('Enter page banner image. It will work as default banner image for the page.'),
                                                    'desc' => __('Upload banner image.'),
                                                    'default'  => array(
                                                        'url'=> ''
                                                    ), 
                                                    'depend_on' => array(
                                                        $pg_id . '_page_banner_type' => array('operator' => '==',"value" => 'image')
                                                    ),

                                                ),
                                                
                                                array(
                                                    'id'     => $pg_id . '-img-banner-section-end',
                                                    'type'   => 'section',
                                                    'indent' => false,
                                                )
                                            );
                
                $page_sorting = array(
                                    array(
                                       'id' => $pg_id . '-sidebar-section-start',
                                       'type' => 'section',
                                       'title' => __('Sidebar Setting'),
                                       'indent' => true
                                    ),
                                    array(
                                        'id'       => $pg_id . '_page_show_sidebar',
                                        'type'     => 'switch',
                                        'title'    => __('Sidebar'),
                                        'on'       => __('Enabled'),
                                        'off'       => __('Disabled'),
                                        'default'  => true
                                    ),
                                    array(
                                        'id'       => $pg_id . '_page_sidebar_layout',
                                        'type'     => 'image_select',
                                        'title'    => __('Sidebar Layout'),
                                        'subtitle' => __('Choose the layout for the page. (Default : Right Side).'),
                                        'options'  => $this->sidebar_layout_options,
                                        'default'  => 'right',
                                        'depend_on' => array(
                                            $pg_id . '_page_show_sidebar' => array('operator' => '==',"value" => '1')
                                        ),
                                    ),
                                    array(
                                        'id'     => $pg_id . '-sidebar-section-end',
                                        'type'   => 'section',
                                        'indent' => false,
                                    ),
                                );
                
                if($pg_id != 'woocommerce')
                {
                    $page_pagination = array(
                                            array(
                                                'id'       => $pg_id . '_page_paging',
                                                'type'     => 'button_set',
                                                'title'    => __('Pagination '),
                                                'options'  => array(
                                                    'default'  => __('Default'),
                                                    'load_more'  => __('Load More'),
                                                    
                                                ),
                                                'default'  => 'default',
                                                'force_output' => true
                                            ),
                                            array(
                                                'id'       => $pg_id . '_page_sorting_on',
                                                'type'     => 'switch',
                                                'title'    => __('Sorting'),
                                                'on'       => __('Enabled'),
                                                'off'       => __('Disabled'),
                                                'default'  => true
                                            ),
                                            array(
                                                'id'       => $pg_id . '_page_sorting',
                                                'type'     => 'select',
                                                'title'    => __('Select Sorting'),
                                                'subtitle'    => __('Select Sorting'),
                                                'desc'    => __('Select Sorting'),
                                                'options'  => $this->sort_by_options,
                                                'default'  => 'date_asc',
                                                'force_output' => true,
                                                'depend_on' => array(
                                                    $pg_id . '_page_sorting_on' => array('operator' => '==',"value" => '1')
                                                ),
                                            ),
                                            
                    
                                        );
                }
                
                $final_page_options  = array_merge($page_default_settings,$page_sorting,$page_pagination);
                
                $this->sections[] = array(
                    'title'  =>  $pg_name . __(' Page'),
                    'icon'   => $pg_icon,
                    'desc'   => '',
                    'subsection' => true,
                    'fields' => $final_page_options,
                );
                
                
                
                
            }
            
            $this->sections[] = array(
                    'title'  =>  __('404 Page'),
                    'icon'   => 'fas fa-exclamation-triangle',
                    'desc'   => '',
                    'subsection' => true,
                    'fields' => array(
                        array(
                            'id'       => 'error_page_title',
                            'type'     => 'text',
                            'title'    => __('Page Title'),
                            'default'  => __('404'),
                            'force_output' => true
                        ),
                        array(
                            'id'       => 'error_page_template',
                            'type'     => 'image_select',
                            'height'   => '80',
                            'title'    => __('404 Template'),
                            'subtitle' => __('Select a template for the page.'),
                            'options'  => array('error_style_1'=>asset('themes/frontend/lemars/images/page-template/error-404.png')),
                            'default'  => 'error_style_1'
                        ),
                        array(
                            'id'       => 'error_page_text',
                            'type'     => 'textarea',
                            'title'    => __('404 Page Text'),
                            'default'  => __('We are sorry. But the page you are looking for cannot be found.')
                        ),
                        array(
                            'id'       => 'error_page_button_text',
                            'type'     => 'text',
                            'title'    => __('404 Page Button Text'),
                            'default'  => __('Back to Home')
                        ),
                    )
                );

            /*--------------------------------------------------------------
            # 7. Category Setting
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title'  => __('Category Settings'),
                'icon'   => 'fas fa-list-alt'
            );
            
            $args = array(
                'type'       => 'post',
                'orderby'    => 'name',
                'order'      => 'ASC',
                'hide_empty' => 0,
                'taxonomy'   => 'category'
            );

            $categories = \App\Models\BlogCategory::latest()->pluck('title','slug')->toArray();
            if (!empty($categories)) {
                foreach ($categories as $category_slug => $category_title) {
                 
                    $this->sections[] = array(
                        'title'  => __('Category').' '.$category_title,
                        'icon'   => 'el el-cog-alt',
                        'subsection' => true,
                        'fields' => array(
                            array(
                                'id'       => 'category_' . $category_slug. '_image',
                                'type'     => 'media',
                                'url'      => true,
                                'title'    => __('Category Small Image'),
                                'subtitle' => __('Enter category image.'),
                                'desc' => __('Upload category image.'),
                                'default'  => ''
                            )
                        )
                    );
                }
            }


            /*--------------------------------------------------------------
            # 11. Social Setting
            --------------------------------------------------------------*/
            $this->sections[] = array(
                'title'   => __('Social Setting'),
                'icon'    => 'fab fa-twitter',
            );
            
            $socialLinkFiels[] = array(
                'id'       => 'social_link_target',
                'type'     => 'select',
                'title'    => __('Choose Social Link Target'),
                'options'  => $this->link_target_options,
                'default'  => '_self'
            );

            foreach ($this->social_link_options as $social_link) {
            
                $sl_id = $social_link['id'];
                $sl_title = $social_link['title'];

                $socialLinkFiels[] = array(
                    'id'      => 'social_' . $sl_id . '_url',
                    'type'    => 'text',
                    'title'   => $sl_title . __(' URL'),
                    'subtitle'   => __('Link to : ') . $sl_title,
                    'default' => '',
                );
            }

            $this->sections[] = array(
                'title'  => __('Social Link'),
                'icon'   => 'fab fa-facebook',
                'subsection' => true,
                'fields' => $socialLinkFiels
            );

            $social_share_list = $social_share_default = array();
            $i = 1;
            foreach ($this->social_share_options as $social_link) {

                $social_share_list[$social_link['id']] = $social_link['title'];

                if($i <= 3 ) {
                    $social_share_default[$social_link['id']] = true;
                }
                else {
                    $social_share_default[$social_link['id']] = false;
                }
                $i++;
            }


            $this->sections[] = array(
                'title'  => __('Social Sharing'),
                'icon'   => 'fab fa-facebook',
                'subsection' => true,
                'fields' => array(
                    array(
                        'id'       => 'social_shaing_on_post',
                        'type'     => 'switch',
                        'title'    => __('Enable Social Shaing On Post'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false
                    ),
                    array(
                        'id'       => 'social_shaing_on_page',
                        'type'     => 'switch',
                        'title'    => __('Enable Social Shaing On Page'),
                        'on'       => __('Enabled'),
                        'off'       => __('Disabled'),
                        'default'  => false
                    ),
                )
            );


        }
    }
}
